import {EApiEntry} from 'types/EApiEntry';
import IGetContextPageResponse from './types/IGetContextPageResponse';
import IGetContextPageRequestParams from './types/IGetContextPageRequestParams';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class TemplatorApi extends RestApiClient {
    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        requestId,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: `${getApiHost(EApiEntry.TEMPLATOR)}`,
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.TEMPLATOR);
    }

    async getContextPage<T>(
        params: IGetContextPageRequestParams,
    ): Promise<IGetContextPageResponse<T>> {
        return this.get<IGetContextPageResponse<T>>('/getContextPage', {
            params,
        });
    }
}
