import {EContentPageType} from 'projects/journal/types/EContentPageType';
import {TJournalArticleBlock} from 'projects/journal/types/article/TJournalArticleBlock';

export enum EAuthorType {
    TYPICAL = 'typical',
    ZEN = 'zen',
    /** Автор Яндекс.Путешествий */
    TRAVEL = 'travel',
}

export interface IContextPageAuthor {
    name: string;
    type?: EAuthorType;
    avatar: string;
    description?: string;
    url?: string;
}

export interface IContextPageSeo {
    title: string;
    description: string;
    image: string;
}

export interface IBaseJournalPage {
    type: EContentPageType;
    semanticId: string;
    seo: IContextPageSeo;
}

export interface IMetaArticle extends IBaseJournalPage {
    tagId: string;
    title: string;
}

export interface IGetContextPageArticle extends IBaseJournalPage {
    semanticPrefix?: string;
    pageTitle: string;
    articleImg: string;
    author: IContextPageAuthor;
    createdDate: string; // DD.MM.YYYY
    dateModified?: string; // YYYY-MM-DDTHH:mm:ssZ
    tags: string[]; // Может быть пустым []
    pageContent: TJournalArticleBlock[];
}

export default interface IGetContextPageResponse<T = IGetContextPageArticle> {
    result: T[]; // Может быть пустым []
}

export interface IGetContextPageTag extends IBaseJournalPage {
    tagId: string;
    title: string;
    tagImg: string;
    color: string;
    tagDescription: string;
    semanticPrefix?: string;
}
