import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import IGetToursWidgetInfoApiResponse from 'server/api/ToursApi/types/IGetToursWidgetInfoApiResponse';
import IBindToursApiRequestParams from 'server/api/ToursApi/types/IBindToursApiRequestParams';
import {TBindToursApiResponse} from 'server/api/ToursApi/types/TBindToursApiResponse';
import IGetToursWidgetInfoApiRequestParams from 'server/api/ToursApi/types/IGetToursWidgetInfoApiRequestParams';

import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';
import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class ToursApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        getServiceTicket,
        requestId,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: `${getApiHost(EApiEntry.TRAVEL)}/tours_whitelabel`,
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.TRAVEL);
        this.serviceTicket = getServiceTicket('travelAPI');
    }

    async getToursWidgetInfo(
        params: IGetToursWidgetInfoApiRequestParams,
    ): Promise<IGetToursWidgetInfoApiResponse> {
        return this.get<IGetToursWidgetInfoApiResponse>('/v1/get_widget_info', {
            params,
        });
    }

    async bindTour(
        params: IBindToursApiRequestParams,
    ): Promise<TBindToursApiResponse> {
        return this.post<TBindToursApiResponse>('/v1/bind_tour', undefined, {
            params,
        });
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
            [CommonHeaders.X_YA_USE_CAMELCASE]: 'true',
        };
    }
}
