export enum EBindingCreationStatus {
    /** Такого заказа нет. Либо ошибка в номере/датах, либо заказ сделан несколько минут назад и ещё не получен нами */
    ORDER_NOT_FOUND = 'ORDER_NOT_FOUND',
    /** Заказ уже привязан к текущему пользователю */
    ALREADY_BOUND_TO_CURRENT_USER = 'ALREADY_BOUND_TO_CURRENT_USER',
    /** Заказ уже привязан к какому-то другому пользователю */
    ALREADY_BOUND_TO_OTHER_USER = 'ALREADY_BOUND_TO_OTHER_USER',
    /** Заказ сделан не после перехода с яндекс путешествий (aka прямой заход) */
    NO_LABEL = 'NO_LABEL',
    /** Заказ уже привязан к пользователю, но пользователь не был плюсовиком в момент заказа */
    NON_PLUS_ON_PURCHASE = 'NON_PLUS_ON_PURCHASE',
    /** Заказ слишком старый */
    ORDER_IS_TOO_OLD = 'ORDER_IS_TOO_OLD',
    /** Привязка создана */
    CREATED = 'CREATED',
    /** Добавлено только на клиенте, на случай фоллбека при ошибке */
    ERROR = 'ERROR',
}

type TWithDateStatus =
    | EBindingCreationStatus.CREATED
    | EBindingCreationStatus.ALREADY_BOUND_TO_CURRENT_USER;

export type TBindToursApiResponse =
    | {
          creationStatus: TWithDateStatus;
          expectedTopupDate: string;
      }
    | {
          creationStatus: Exclude<EBindingCreationStatus, TWithDateStatus>;
          expectedTopupDate?: never;
      };
