import {ITrainsOrderDetails} from 'reducers/trains/order/types';

export enum ETrainApiOrderStatus {
    RESERVED = 'reserved',
    CANCELLED = 'cancelled',
    CONFIRM_FAILED = 'confirm_failed',
    START_PAYMENT_FAILED = 'start_payment_failed',
    PAYMENT_FAILED = 'payment_failed',
    UNHANDLED_EXCEPTION_STATE = 'unhandled_exception_state',
    IN_PROGRESS = 'in_progress',
    WAITING_REFUND = 'waiting_refund',
    PAID = 'paid',
    DONE = 'done',
}

interface ITrainApiStation {
    id: number;
    popularTitle: string;
    title: string;
}

export default interface ITrainsApiOrderDetails
    extends Omit<
        ITrainsOrderDetails,
        'status' | 'startStation' | 'endStation'
    > {
    status: ETrainApiOrderStatus;
    startStation: ITrainApiStation;
    endStation: ITrainApiStation;
}
