import {PLACE_RESERVATION_TYPE} from 'projects/trains/constants/placeReservationType';
import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';
import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';
import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {ERoutePolicy} from 'projects/trains/constants/routePolicy';
import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

import {
    IReservationVariant,
    ITrainsCoachTariff,
} from 'reducers/trains/order/types';
import {IStationSettlement} from 'projects/trains/lib/segments/types';
import {ITrainsCoachPriceWithoutPlaces} from 'types/trains/booking/coach/ITrainsCoachPriceWithoutPlaces';

import IPrice from 'utilities/currency/PriceInterface';

// TODO TRAINS: дополнить до всех вариантов
export interface ISchemaPlaceFlags {
    secondStorey: number[];
    lower: number[];
    nearToilet: number[];
    nearWindow: number[];
    genderTipUp: number[];
    side: number[];
    upper: number[];
    middle: number[];
    compartments: number[][];
    sections: number[][];
    groupsInRows: number[][];
    twinRoom: number[];
}

export interface ITrainsSchemaPlace {
    geometry: {
        top: number;
        left: number;
    };
    groupNumber: number;
    number: number;
}

export interface ITrainsSchema {
    height: number;
    width: number;
    hidePlaceNumbers: boolean;
    id: number;
    placeFlags: ISchemaPlaceFlags;
    placeSelectionAlgorithm: string;
    places: ITrainsSchemaPlace[];
    svg: string;
    url: string;
}

interface ITrainsDetailsStation {
    expressCode: string;
    id: number;
    settlement?: IStationSettlement;
}

export interface ITrainsCoachPlaceServer {
    adultTariff: IPrice;
    gender: GENDER_TYPE | null;
    number: number;
    beddingTariffWithFee: IPrice;
    childTariff: IPrice;
    adultNonRefundableTariff: IPrice | null;
    childNonRefundableTariff: IPrice | null;

    // TODO trains: проверить, что поле еще есть
    groupNumber?: number;
}

export enum TrainPlaceType {
    USUAL = 'Usual',
    UPPER = 'Upper',
    LOWER = 'Lower',
    SIDE_LOWER = 'SideLower',
    SIDE_UPPER = 'SideUpper',

    WITH_PETS = 'WithPets',
    NEAR_TABLE_FORWARD = 'NearTableForward',
    NEAR_TABLE_BACKWARD = 'NearTableBackward',
    NO_TABLE_FORWARD = 'NoTableForward',
    NO_TABLE_BACKWARD = 'NoTableBackward',
    NO_WINDOW_FORWARD = 'NoWindowForward',
    NO_WINDOW_BACKWARD = 'NoWindowBackward',
    SINGLE_FORWARD = 'SingleForward',
    SIDE_UPPER_NEAR_RESTROOM = 'SideUpperNearRestroom',
    LAST_KUPE_UPPER = 'LastKupeUpper',
}

export interface ICoachServiceClass {
    internationalCode: string;
    code: string;
    description?: string;
    key: string;
    title: string;
}

export interface ITrainsCoachServer {
    adultTariff: IPrice;
    arrival: string;
    beddingTariff: IPrice;
    canChooseBedding: boolean;
    coachSubtypeCode: string;
    directionConfirmed: boolean;
    electronicTicket: boolean;
    facilities: string[];
    hasDynamicPricing: boolean;
    isFirm: boolean;
    loyaltyCards: TRAIN_BONUS_CARDS[];
    number: string;
    owner: string;
    petInCoach: boolean;
    petsAllowed: boolean;
    petsSegregated: boolean;
    placeCounts: {
        upperSide: number;
        lowerSide: number;
        upperCoupe: number;
        lowerCoupe: number;
        total: number;
    };
    priceWithoutPlaces?: ITrainsCoachPriceWithoutPlaces;
    placeReservationType: PLACE_RESERVATION_TYPE;
    places: ITrainsCoachPlaceServer[];
    placesByCompartment: number[][];
    placesByType?: Record<TrainPlaceType, number[]>;
    reservationVariants: IReservationVariant[] | null;
    schemaId: number | null;
    serviceClass: ICoachServiceClass;
    tariffsInfo: ITrainsCoachTariff[];
    hasNonRefundableTariff: boolean;
    throughArrival: string | null;
    trainStartNumber: string;
    twoStorey: boolean;
    type: TRAIN_COACH_TYPE;
    placeRequirementsAvailable: boolean;
    feeCalculationToken: string;
    gender?: GENDER_TYPE; // проверить, приходит ли вообще данное поле.
}

export enum TrainsTariffCategoryCode {
    BABY = 'baby',
    CHILD = 'child',
    FULL = 'full',
}

export interface ITrainsTariffCategory {
    minAge: number;
    minAgeIncludesBirthday: boolean;
    maxAge: number;
    maxAgeIncludesBirthday: boolean;
    withoutPlace: boolean;
    needDocument: boolean;
    code: TrainsTariffCategoryCode;
}

export interface ITrainsDetailsServer {
    allowedDocumentTypes: TRAINS_DOCUMENT_TYPES[];
    arrival: string;
    coaches?: ITrainsCoachServer[];
    departure: string;
    electronicTicket: boolean;
    isFirm: boolean;
    isSuburban: boolean;
    rawTrainCategory: string;
    rawTrainName: string;
    schemas: ITrainsSchema[];
    startNumber: string;
    stationFrom: ITrainsDetailsStation;
    stationTo: ITrainsDetailsStation;
    ticketNumber: string;
    imInitialStationName: string;
    imFinalStationName: string;
    tariffCategories: ITrainsTariffCategory[];
    isCppk: boolean;
    isCovidCertificateRequired: boolean;
    routePolicy: ERoutePolicy;
    provider: string;
}

export interface ITrainsDetailsApiResponse {
    trainDetails?: ITrainsDetailsServer;
    errors?: boolean;
    partnerError?: any;
}
