import {ITrainOrderApiSegment} from 'server/api/RaspApi/types/IRaspGetTrainOrderSegmentApi/models';
import {
    ICompany,
    IStation,
    IThread,
    ITransport,
    TTariffClasses,
    TTrainsBrokenClasses,
} from 'projects/trains/lib/segments/types';

export interface ITrainsTariffs {
    brokenClasses?: TTrainsBrokenClasses;
    classes?: TTariffClasses;
    electronicTicket: boolean;
}

export interface ITrainsTariffApiSegment {
    arrival: string;
    company: ICompany;
    departure: string;
    duration: number;
    isInterval: boolean;
    isThroughTrain: boolean;
    number: string;
    stationFrom: IStation;
    stationTo: IStation;
    title: string;
    transport: ITransport;

    companies?: ICompany[];
    maxArrival?: string;
    minArrival?: string;
    subSegments?: ITrainOrderApiSegment[];

    oldUfsOrder?: boolean; // проверить, скорее всего перенести в тарифы

    canSupplySegments: boolean;
    hasDynamicPricing: boolean;
    isSuburban: boolean;
    key: string;
    originalNumber: string;
    rawTrainCategory: string;
    rawTrainName: null;
    tariffs: ITrainsTariffs;
    twoStorey: boolean;
    ufsTitle: string;
    thread: IThread | null;
}
