import {TrainsOrderStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderStatus';
import {ETrainApiOrderStatus} from 'server/api/TrainsApi/types/ITrainsApiOrderDetails';

/**
 * Для заказов из train-api преобразуем статус к travel-api
 */
export default function prepareTrainApiOrderStatus(
    status: ETrainApiOrderStatus,
): TrainsOrderStatus {
    switch (status) {
        case ETrainApiOrderStatus.DONE:
            return TrainsOrderStatus.CONFIRMED;
        case ETrainApiOrderStatus.CANCELLED:
            return TrainsOrderStatus.CANCELLED;
        case ETrainApiOrderStatus.RESERVED:
        case ETrainApiOrderStatus.CONFIRM_FAILED:
        case ETrainApiOrderStatus.START_PAYMENT_FAILED:
        case ETrainApiOrderStatus.PAYMENT_FAILED:
        case ETrainApiOrderStatus.UNHANDLED_EXCEPTION_STATE:
        case ETrainApiOrderStatus.IN_PROGRESS:
        case ETrainApiOrderStatus.WAITING_REFUND:
        case ETrainApiOrderStatus.PAID:
            return TrainsOrderStatus.IN_PROGRESS;
    }
}
