import {ARRANGEMENT_REQUIREMENTS} from 'projects/trains/constants/requirements';

import {CountRequirementsType} from 'reducers/trains/order/types';

export default interface ITrainsCreateOrderRequirements {
    /**
     * Расположение пассажиров.
     * Например, рядом, в одном купе.
     */
    arrangement?: ARRANGEMENT_REQUIREMENTS;

    /**
     * Номер этажа для двухэтажных вагонов.
     */
    storey?: number;

    /**
     * Количество мест по требованиям к местам.
     */
    count?: CountRequirementsType;
}
