export default interface ITrainsCreateOrderSource {
    /**
     * UTM-метки.
     */
    utmSource?: string;
    utmMedium?: string;
    utmCampaign?: string;
    utmTerm?: string;
    utmContent?: string;

    /**
     * Источник перехода.
     * Например, у нас есть 301 редирект с trains.yandex.ru, который добавляет
     * в get-параметры значение from.
     */
    from?: string;

    /**
     * Google click ID.
     * Когда пользователь нажимает на объявление, автоматически добавляется параметр gclid.
     */
    gclid?: string;

    /**
     * TODO: что это и для чего?
     * Дублирование с userInfo. Там есть isMobile.
     */
    device: 'touch' | 'desktop';

    /**
     * Нужен для trust.
     * promo_mir_rasp нужен для промо с МИР, чтобы для их карт был повышекнный кэшбэк.
     * Еще есть trains, который использовался на trains.yandex.ru.
     */
    terminal: 'travel' | 'promo_mir_rasp';

    /**
     * Является ли маршрут заказа частью общего маршрута с пересадками.
     */
    isTransfer: boolean;
}
