import {TrainsOrderStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderStatus';
import {TrainsInsuranceStatus} from 'server/api/TrainsBookingApi/types/TrainsInsuranceStatus';
import {TrainsOrderCompartmentGender} from 'server/api/TrainsBookingApi/types/TrainsOrderCompartmentGender';
import ITrainsOrderInfoPassenger from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoPassenger';
import ITrainsOrderInfoStation from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoStation';
import ITrainsOrderInfoTrainInfo from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTrainInfo';
import ITrainsOrderInfoWarning from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoWarning';
import EOriginalPaymentErrorCode from 'types/common/EOriginalPaymentErrorCode';
import IErrorInfo from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/IErrorInfo/IErrorInfo';
import {TGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';

import IPrice from 'utilities/currency/PriceInterface';

export enum TrainsOrderRefundStatus {
    IN_PROGRESS = 'IN_PROGRESS',
    SUCCESS = 'SUCCESS',
    FAIL = 'FAIL',
}

export enum TrainsOrderRefundType {
    USER_REFUND = 'USER_REFUND',
    OFFICE_REFUND = 'OFFICE_REFUND',
    INSURANCE_AUTO_RETURN = 'INSURANCE_AUTO_RETURN',
}

export interface ITrainsOrderRefund {
    createdAt: string;
    status: TrainsOrderRefundStatus;
    type: TrainsOrderRefundType;
    tickets: {
        amount: IPrice;
        blankId: number;
    }[];
    paymentReceiptUrl: string | null;
}

export default interface ITrainsOrderInfoResponse {
    arrival: string;
    carNumber: string;
    carType: string;
    coachOwner: string;
    companyTitle: string;
    compartmentGender: TrainsOrderCompartmentGender | null;
    customerEmail: string;
    customerPhone: string;
    departure: string;
    error: IErrorInfo | null;
    id: string; // UID заказа
    insuranceStatus: TrainsInsuranceStatus;
    onlyFullReturnPossible: boolean;
    partner: 'im';
    partnerOrderId: number; // Номер заказа у партнера
    passengers: ITrainsOrderInfoPassenger[];
    refunds?: ITrainsOrderRefund[];
    paymentCode: EOriginalPaymentErrorCode | null;
    paymentUrl: string | null;
    prettyId: string; // "Красивый" номер заказа в Оркестраторе
    reservationNumber: string; // Номер от партнера (РЖД)
    rebookingAvailable: boolean;
    reservationProlonged: boolean;
    reservedTo: string;
    specialNotice: string | null;
    stationFrom: ITrainsOrderInfoStation;
    stationTo: ITrainsOrderInfoStation;
    status: TrainsOrderStatus;
    trainInfo: ITrainsOrderInfoTrainInfo;
    twoStorey: boolean;
    warnings: ITrainsOrderInfoWarning[];
    paymentReceiptUrl: string;
    isFullRefundPossible: boolean;

    services: TGenericService[];
}
