import ITrainsOrderInfoTicketPlace from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicketPlace';
import ITrainsOrderInfoTicketTariffInfo from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicketTariffInfo';
import ITrainsOrderInfoTicketPayment from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicketPayment';
import {TrainsOrderInfoTicketRzhdStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderInfoTicketRzhdStatus';

import IPrice from 'utilities/currency/PriceInterface';

export enum TrainBookedTariffCode {
    FAMILY = 'family',
    HAPPY = 'happy',
    SENIOR = 'senior',
    JUNIOR = 'junior',
    PUPIL = 'pupil',
    CHILD_17 = 'child_17',
    CHILD = 'child',
    BABY = 'baby',
    FULL = 'full',
}

export default interface ITrainsOrderInfoTicket {
    places: ITrainsOrderInfoTicketPlace[];
    tariffInfo: ITrainsOrderInfoTicketTariffInfo | null;
    rzhdStatus: TrainsOrderInfoTicketRzhdStatus | null;
    amount: IPrice;
    rawTariffTitle: string;
    bookedTariffCode: TrainBookedTariffCode | null; // TODO TRAINS: убрать null, когда проставят в старых заказах
    payment: ITrainsOrderInfoTicketPayment;
    blankId: number;
    pending: boolean;
    moneyReturned: boolean;
    refunding: boolean;
    refundable: boolean;
    /**
     * https://st.yandex-team.ru/TRAVELFRONT-3629
     */
    canChangeElectronicRegistrationTill: string | null;
    canReturnTill: string | null;
}
