/**
 * Результат получения цены страховки
 */
export enum EInsurancePricingOutcome {
    UNKNOWN = 'IPO_UNKNOWN',
    SUCCESS = 'IPO_SUCCESS',
    FAILURE = 'IPO_FAILURE',
}

/**
 * Результат выписывания страховки
 */
export enum EInsuranceCheckoutOutcome {
    UNKNOWN = 'ICO_UNKNOWN',
    SUCCESS = 'ICO_SUCCESS',
    FAILURE = 'ICO_FAILURE',
}

/**
 * Результат подтверждения выписанной страховки (после оплаты)
 */
export enum EInsuranceCheckoutConfirmOutcome {
    UNKNOWN = 'ICCO_UNKNOWN',
    SUCCESS = 'ICCO_SUCCESS',
    FAILURE = 'ICCO_FAILURE',
}

/**
 * Результат получения стоимости к возврату
 */
export enum ERefundPricingOutcome {
    UNKNOWN = 'RPO_UNKNOWN',
    SUCCESS = 'RPO_SUCCESS',
    FAILURE = 'RPO_FAILURE',
}

/**
 * Результат проведения авто-возврата
 */
export enum ERefundCheckoutOutcome {
    UNKNOWN = 'RCO_UNKNOWN',
    SUCCESS = 'RCO_SUCCESS',
    FAILURE = 'RCO_FAILURE',
}

/**
 * Результат создания бронирования
 */
export enum ECreateReservationOutcome {
    UNKNOWN = 'RCRO_UNKNOWN',
    SUCCESS = 'RCRO_SUCCESS',
    FAILURE = 'RCRO_FAILURE',
}

/**
 * Результат подтверждения бронирования
 */
export enum EConfirmReservationOutcome {
    UNKNOWN = 'RCOO_UNKNOWN',
    SUCCESS = 'RCOO_SUCCESS',
    FAILURE = 'RCOO_FAILURE',
}

/**
 * https://api.travel-balancer-test.yandex.net/swagger-ui.html#/test-context-controller/getTrainTokenUsingGET
 * Select a spec = test
 */
export interface ITrainsTestContextTokenParams {
    insurancePricingOutcome: EInsurancePricingOutcome;
    insuranceCheckoutOutcome: EInsuranceCheckoutOutcome;
    insuranceCheckoutConfirmOutcome: EInsuranceCheckoutConfirmOutcome;

    refundPricingOutcome: ERefundPricingOutcome;
    refundCheckoutOutcome: ERefundCheckoutOutcome;

    createReservationOutcome: ECreateReservationOutcome;

    confirmReservationOutcome: EConfirmReservationOutcome;

    /**
     * Ограничения для таймаутов - стоит ставить не меньше 10 секунд, чтобы не флапало (бывают лаги на беке до 6 с)
     * Период возврата билета через кассу (в секундах). Если не задано или 0 - возврата не будет
     */
    officeReturnDelayInSeconds?: number;
    /**
     * Период получения билета в кассе (в секундах). Если не задано или 0 - билет не должен быть получен в кассе
     */
    officeAcquireDelayInSeconds?: number;
    /**
     * Период времени в секундах, после которого запрос на обновление данных в ИМ будет завершаться таймаутом.
     * Если не задано или 0 - таймаута не будет
     */
    alwaysTimeoutAfterConfirmingInSeconds?: number;
}

export interface ITrainsTestContextTokenAnswer {
    // eslint-disable-next-line camelcase
    test_context_token: string;
}
