export enum TrainsInsuranceStatus {
    /**
     * страховка выключена
     */
    DISABLED = 'DISABLED',
    /**
     * если страховка возможна, то такой статус сразу после создания заказа
     */
    NEW = 'NEW',
    /**
     * страховка включена, цены по страховке получены
     */
    PRICED = 'PRICED',
    /**
     * запрос за ценами по страховке не удался
     */
    PRICING_FAILED = 'PRICING_FAILED',
    /**
     * страховка заказана
     */
    CHECKED_OUT = 'CHECKED_OUT',
    /**
     * заказ страховки не удался
     */
    CHECKOUT_FAILED = 'CHECKOUT_FAILED',
}
