import snakecaseKeys from 'snakecase-keys';

import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import {ITrainsSaveOfferApiParams} from './types/ITrainsSaveOfferApiParams';
import {ITrainsSaveOfferApiResponse} from './types/ITrainsSaveOfferApiResponse';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

export class TrainsOfferStorageApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        requestId,
        rootSpan,
        getServiceTicket,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.TRAINS_OFFER_STORAGE),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.TRAINS_OFFER_STORAGE);
        this.serviceTicket = getServiceTicket('trainsOfferStorageAPI');
    }

    saveOffer(
        params: ITrainsSaveOfferApiParams,
    ): Promise<ITrainsSaveOfferApiResponse> {
        // @ts-ignore
        const body = snakecaseKeys(params, {deep: true});

        return this.post<ITrainsSaveOfferApiResponse>('/store', body, {
            convertResponseKeysToCamelCase: true,
        });
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
        };
    }
}
