/* eslint-disable camelcase */
import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';
import {ETrainsPartner} from 'projects/trains/constants/trainPartners';
import {
    ADDITIONAL_REQUIREMENTS,
    ARRANGEMENT_REQUIREMENTS,
} from 'projects/trains/constants/requirements';
import {ERoutePolicy} from 'projects/trains/constants/routePolicy';

import {ITrainsSource} from 'server/api/TrainsApi/types/ITrainsSource';
import {CountRequirementsType} from 'reducers/trains/order/types';
import ITrainsSaveOfferPassenger from 'server/api/TrainsOfferStorageApi/types/ITrainsSaveOfferPassenger';
import {EDirection} from 'types/common/EDirection';

export interface ITrainsSaveOfferApiParams {
    /**
     * Направление поезда для сложного заказа
     */
    direction: EDirection;

    /**
     * Индекс поезда в пересадках для сложного заказа
     */
    segmentIndex: number;

    /**
     * Номер поезда из вагона.
     * Может отличаться для бесапересадочных вагонов.
     */
    trainNumber: string;
    /**
     * Номер поезда из сегмента.
     */
    trainTicketNumber: string;
    /**
     * Например, «Москва — Санкт-Петербург».
     */
    trainTitle: string;
    /**
     * Например, «Малахит» или «Сапсан.
     */
    brandTitle: string | undefined;
    /**
     * Название перевозчика
     */
    companyTitle: string | undefined;
    /**
     * Поле rawTrainName из trainDetails
     */
    rawTrainName: string;

    /**
     * Express ID странции отправления.
     */
    stationFromId: number;
    /**
     * Express ID странции прибытия.
     */
    stationToId: number;
    /**
     * Время отправления в ISO DateTime с таймзоной.
     */
    departure: string;
    /**
     * Время прибытия в ISO DateTime с таймзоной.
     */
    arrival: string;

    /**
     * Пол выбранных мест в купе.
     */
    cabinGenderKind: GENDER_TYPE | undefined;
    /**
     * Номер вагона.
     * Отсутствует, если есть поле requirements.
     */
    carNumber: string | undefined;
    /**
     * Тип вагона.
     */
    carType: TRAIN_COACH_TYPE;
    /**
     * Код сервисного класса.
     * Например, «3Л» или «2У».
     */
    serviceClass: string;
    /**
     * Есть ли электронная регистрация для данного вагона.
     * Не поддерживается на данный момент
     */
    internationalServiceClass?: string | undefined;
    routePolicy: ERoutePolicy;

    isCppk: boolean;
    schemeId: number | null | undefined;
    electronicRegistration: boolean;
    /**
     * Есть ли возможность включать постельное белье в заказ.
     */
    canChooseBedding: boolean;
    /**
     * Включено ли постельное белье в заказ.
     */
    bedding: boolean;
    /**
     * Возможность купить место для ребенка от 5 до 10 лет бесплатно.
     * Не поддерживается на данный момент
     */
    giveChildWithoutPlace?: boolean;

    /**
     * Данные пассажиров.
     */
    passengers: ITrainsSaveOfferPassenger[];
    /**
     * Места в вагоне.
     */
    places: number[];

    /**
     * Требования к местам.
     */
    requirements: ITrainsCreateOrderRequirements | undefined;
    /**
     * Дополнительное требование к местам.
     * Например, сиденья по направлению движения.
     */
    additionalPlaceRequirements: ADDITIONAL_REQUIREMENTS | undefined;

    /**
     * Партнер
     */
    partner: ETrainsPartner;

    /**
     * Информация откуда пришел пользователь.
     */
    labelParams: ITrainsSource;

    /**
     * Начальная станция, с которой отправляется поезд. От партнера.
     */
    imInitialStationName: string;
    /**
     * Конечная станция, на которую прибывает поезд. От партнера.
     */
    imFinalStationName: string;

    /**
     * Итоговая сумма в рублях
     */
    amount: number;

    /**
     * Поставщик услуг "Экспресс", "Мовиста" от ИМ
     */
    provider: string;

    /**
     * Динамическая наценка
     */

    feeCalculationToken: string;

    /**
     * Параметры которые проставляются на беке в TrainsService
     */
    wizard_req_id?: string | undefined;
    serp_test_id?: string | undefined;
    metrikaClientId?: string | undefined;
}

interface ITrainsCreateOrderRequirements {
    arrangement?: ARRANGEMENT_REQUIREMENTS;
    number?: number;
    count?: CountRequirementsType;
}
