import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';
import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import ITrainsCreateOrderLoyaltyCard from 'server/api/TrainsBookingApi/types/ITrainsCreateOrderLoyaltyCard';

export default interface ITrainsSaveOfferPassenger {
    /**
     * Индекс пассажира
     */
    index: number;
    /**
     * Пол пассажира.
     */
    sex: 'M' | 'F';
    /**
     * Тип документа.
     */
    docType: TRAINS_DOCUMENT_TYPES;
    /**
     * GeoId страны, гражданство которой имеет пассажир.
     */
    citizenshipGeoId: number;
    /**
     * Тарифная группа.
     * Например, «full», «child», «child_17», «pupil», «baby».
     */
    tariff: string;
    /**
     * Был выбран невозвратный тариф
     */
    isNonRefundableTariff: boolean;
    /**
     * Возрастная группа.
     */
    ageGroup: PASSENGERS_TYPES;
    /**
     * Бонусные карты.
     */
    loyaltyCards: ITrainsCreateOrderLoyaltyCard[];
    /**
     * Места для пассажира.
     */
    places?: number[];
}
