import {ITrainsSearchInfoResponse} from '../types/ITrainsSearch';
import {EQueryingStatus} from 'types/trains/search/searchInfo/ITrainsSearchInfo';
import {ETrainsFeatureType} from 'types/trains/common/features/ETrainsFeatureType';
import {ETrainsBrokenClassesCode} from 'types/trains/common/tariffs/ETrainsBrokenClassesCode';
import {ETrainsCoachType} from 'types/trains/common/tariffs/ETrainsCoachType';
import {ETrainsVariantUrlOwner} from 'types/trains/common/variant/ETrainsVariantUrlOwner';
import {ENearestTrainDatesReason} from 'types/trains/search/searchInfo/INearestTrainDates';

import {CurrencyType} from 'utilities/currency/CurrencyType';

export const trainsSearchResponse: ITrainsSearchInfoResponse = {
    status: EQueryingStatus.DONE,
    variants: [
        {
            id: '2006004-9602494-2021-0-01T02:45-train_9602499-9603162-2021-03-01T07:20-trai',
            forward: [
                {
                    id: '1234',
                    departure: '2021-03-01T02:45:00Z',
                    arrival: '2021-03-01T10:15:00Z',
                    duration: 12312,
                    provider: 'P1',
                    stationFrom: {
                        id: 2006004,
                        title: 'Ленинградский вокзал',
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9602494,
                        title: 'Московский вокзал',
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 4240,
                        title: 'РЖД/ДОСС',
                    },
                    features: {
                        namedTrain: {
                            id: 258,
                            type: ETrainsFeatureType.NAMED_TRAIN,
                            title: 'Сапсан',
                            isHighSpeed: true,
                            isDeluxe: false,
                        },
                        [ETrainsFeatureType.THROUGH_TRAIN]: {
                            type: ETrainsFeatureType.THROUGH_TRAIN,
                        },
                        [ETrainsFeatureType.SUBTYPE]: {
                            type: ETrainsFeatureType.SUBTYPE,
                            title: 'Экспресс',
                            id: 1233,
                        },
                    },
                    train: {
                        number: '020Y',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        classes: {
                            sitting: {
                                price: {
                                    value: 23444,
                                    currency: CurrencyType.RUB,
                                },
                                seats: 452,
                                type: ETrainsCoachType.SITTING,
                            },
                        },
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
        {
            id: '20062304-9602494-021-03-01T02:45-train_9602499-9603162-2021-03-01T07:20-train',
            forward: [
                {
                    id: '1234',
                    departure: '2021-03-01T01:45:00Z',
                    arrival: '2021-03-01T08:15:00Z',
                    duration: 13341,
                    provider: 'P1',
                    stationFrom: {
                        id: 2006004,
                        title: 'Ленинградский вокзал',
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9602494,
                        title: 'Московский вокзал',
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 4240,
                        title: 'РЖД/ДОСС',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        namedTrain: {
                            id: 258,
                            type: ETrainsFeatureType.NAMED_TRAIN,
                            title: 'Сапсан2',
                            isHighSpeed: true,
                            isDeluxe: false,
                        },
                        [ETrainsFeatureType.SUBTYPE]: {
                            type: ETrainsFeatureType.SUBTYPE,
                            title: 'Экспресс',
                            id: 1233,
                        },
                    },
                    train: {
                        number: '056Y',
                        title: 'Москва - Санкт',
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
        {
            id: '2006004-9602494-021-03-01T02:45-train_9602499-9603162-2021-03-01T07:20-train',
            forward: [
                {
                    id: '1234',
                    departure: '2021-03-01T01:45:00Z',
                    arrival: '2021-03-01T08:15:00Z',
                    duration: 13341,
                    provider: 'P1',
                    stationFrom: {
                        id: 2006004,
                        title: 'Ленинградский вокзал',
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9602494,
                        title: 'Московский вокзал',
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 4240,
                        title: 'РЖД/ДОСС',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        namedTrain: {
                            id: 258,
                            type: ETrainsFeatureType.NAMED_TRAIN,
                            title: 'Сапсан2',
                            isHighSpeed: true,
                            isDeluxe: false,
                        },
                        [ETrainsFeatureType.SUBTYPE]: {
                            type: ETrainsFeatureType.SUBTYPE,
                            title: 'Экспресс',
                            id: 1233,
                        },
                    },
                    train: {
                        number: '056Y',
                        title: 'Москва - Санкт',
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
        {
            id: '2006004-92494-2021-03-01T02:45-train_9602499-9603162-2021-03-01T07:20-train',
            forward: [
                {
                    id: '1234',
                    departure: '2021-03-01T02:45:00Z',
                    arrival: '2021-03-01T06:15:00Z',
                    duration: 12312,
                    provider: 'P1',
                    stationFrom: {
                        id: 2006004,
                        title: 'Ленинградский вокзал',
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9602494,
                        title: 'Московский вокзал',
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 4240,
                        title: 'РЖД/ДОСС',
                    },
                    features: {
                        namedTrain: {
                            id: 258,
                            type: ETrainsFeatureType.NAMED_TRAIN,
                            title: 'Сапсан',
                            isHighSpeed: true,
                            isDeluxe: false,
                        },
                        [ETrainsFeatureType.SUBTYPE]: {
                            type: ETrainsFeatureType.SUBTYPE,
                            title: 'Экспресс',
                            id: 1233,
                        },
                    },
                    train: {
                        number: '020Y',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        brokenClassesCode: ETrainsBrokenClassesCode.SOLD_OUT,
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
        {
            id: '2006004-9602494-2021-03-01T06:40-train_9602499-9603162-2021-03-01T11:54-train',
            forward: [
                {
                    id: '34234',
                    duration: 3424,
                    provider: 'P1',
                    departure: '2021-03-01T06:40:00Z',
                    arrival: '2021-03-01T10:30:00Z',
                    train: {
                        number: 'rfFD2',
                        title: 'Москва - Санкт2',
                    },
                    stationFrom: {
                        id: 2006004,
                        title: 'Ленинградский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9602494,
                        title: 'Московский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 4240,
                        title: 'РЖД/ДОСС',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        [ETrainsFeatureType.SUBTYPE]: {
                            type: ETrainsFeatureType.SUBTYPE,
                            title: 'Экспресс',
                            id: 1233,
                        },
                    },
                    tariffs: {
                        brokenClassesCode: ETrainsBrokenClassesCode.OTHER,
                    },
                },
                {
                    id: '342342',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-01T11:54:00Z',
                    arrival: '2021-03-01T14:54:00Z',
                    stationFrom: {
                        id: 9602499,
                        title: 'Ладожский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9604211,
                        title: 'Череповец-1',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 968,
                            preposition: 'в',
                            title: 'Череповец',
                            titleAccusative: 'Череповец',
                            titleGenitive: 'Череповца',
                            titleLocative: 'Череповце',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 112,
                        title: 'РЖД/ФПК',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        dynamicPricing: {
                            type: ETrainsFeatureType.DYNAMIC_PRICING,
                        },
                    },
                    train: {
                        number: 'zd12',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        brokenClassesCode: ETrainsBrokenClassesCode.SOLD_OUT,
                    },
                },
                {
                    id: '34122342312',
                    duration: 32424,
                    departure: '2021-03-02T06:11:00Z',
                    provider: 'P1',
                    arrival: '2021-03-02T12:02:00Z',
                    stationFrom: {
                        id: 9604211,
                        title: 'Череповец-1',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 968,
                            preposition: 'в',
                            title: 'Череповец',
                            titleAccusative: 'Череповец',
                            titleGenitive: 'Череповца',
                            titleLocative: 'Череповце',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9603162,
                        title: 'Тихвин',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 10892,
                            preposition: 'в',
                            title: 'Тихвин',
                            titleAccusative: 'Тихвин',
                            titleGenitive: 'Тихвина',
                            titleLocative: 'Тихвине',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 112,
                        title: 'РЖД/ФПК',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        dynamicPricing: {
                            type: ETrainsFeatureType.DYNAMIC_PRICING,
                        },
                    },
                    train: {
                        number: 'ed23',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        classes: {
                            platzkarte: {
                                type: ETrainsCoachType.PLATZKARTE,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 90700,
                                },
                                seats: 29,
                            },
                            compartment: {
                                type: ETrainsCoachType.COMPARTMENT,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 12333,
                                },
                                seats: 37,
                            },
                        },
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
        {
            id: '2006004-9602494-2021-03-01T06:40-train_9602499-9603162-2021-03-01T11:54-train',
            forward: [
                {
                    id: '34234',
                    duration: 3424,
                    provider: 'P1',
                    departure: '2021-03-01T06:40:00Z',
                    arrival: '2021-03-01T10:30:00Z',
                    train: {
                        number: 'rfFD2',
                        title: 'Москва - Санкт2',
                    },
                    stationFrom: {
                        id: 2006004,
                        title: 'Ленинградский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9602494,
                        title: 'Московский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 4240,
                        title: 'РЖД/ДОСС',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        [ETrainsFeatureType.SUBTYPE]: {
                            type: ETrainsFeatureType.SUBTYPE,
                            title: 'Экспресс',
                            id: 1233,
                        },
                    },
                },
                {
                    id: '342342',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-01T11:54:00Z',
                    arrival: '2021-03-01T14:54:00Z',
                    stationFrom: {
                        id: 9602499,
                        title: 'Ладожский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9604211,
                        title: 'Череповец-1',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 968,
                            preposition: 'в',
                            title: 'Череповец',
                            titleAccusative: 'Череповец',
                            titleGenitive: 'Череповца',
                            titleLocative: 'Череповце',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 112,
                        title: 'РЖД/ФПК',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        dynamicPricing: {
                            type: ETrainsFeatureType.DYNAMIC_PRICING,
                        },
                    },
                    train: {
                        number: 'zd12',
                        title: 'Москва - Санкт',
                    },
                },
                {
                    id: '34122342312',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-02T06:11:00Z',
                    arrival: '2021-03-02T12:02:00Z',
                    stationFrom: {
                        id: 9604211,
                        title: 'Череповец-1',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 968,
                            preposition: 'в',
                            title: 'Череповец',
                            titleAccusative: 'Череповец',
                            titleGenitive: 'Череповца',
                            titleLocative: 'Череповце',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9603162,
                        title: 'Тихвин',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 10892,
                            preposition: 'в',
                            title: 'Тихвин',
                            titleAccusative: 'Тихвин',
                            titleGenitive: 'Тихвина',
                            titleLocative: 'Тихвине',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 112,
                        title: 'РЖД/ФПК',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        dynamicPricing: {
                            type: ETrainsFeatureType.DYNAMIC_PRICING,
                        },
                    },
                    train: {
                        number: 'ed23',
                        title: 'Москва - Санкт',
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
        {
            id: '2006004-9602494-2021-03-01T12:40-train_9602499-9603162-2021-03-01T17:40-train',
            forward: [
                {
                    id: '342342',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-01T12:40:00Z',
                    arrival: '2021-03-01T16:40:00Z',
                    stationFrom: {
                        id: 2006004,
                        title: 'Ленинградский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9602494,
                        title: 'Московский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 4240,
                        title: 'РЖД/ДОСС',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        namedTrain: {
                            id: 258,
                            type: ETrainsFeatureType.NAMED_TRAIN,
                            title: 'Сапсан',
                            isHighSpeed: true,
                            isDeluxe: false,
                        },
                    },
                    train: {
                        number: 'pe34',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        classes: {
                            sitting: {
                                type: ETrainsCoachType.SITTING,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 209960,
                                },
                                seats: 470,
                            },
                        },
                    },
                },
                {
                    id: '342342',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-01T17:40:00Z',
                    arrival: '2021-03-01T21:04:00Z',
                    stationFrom: {
                        id: 9602499,
                        title: 'Ладожский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9603162,
                        title: 'Тихвин',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 10892,
                            preposition: 'в',
                            title: 'Тихвин',
                            titleAccusative: 'Тихвин',
                            titleGenitive: 'Тихвина',
                            titleLocative: 'Тихвине',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 112,
                        title: 'РЖД/ФПК',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        dynamicPricing: {
                            type: ETrainsFeatureType.DYNAMIC_PRICING,
                        },
                        namedTrain: {
                            id: 188,
                            type: ETrainsFeatureType.NAMED_TRAIN,
                            title: 'Белые ночи',
                            isHighSpeed: false,
                            isDeluxe: true,
                        },
                    },
                    train: {
                        number: 'er12',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        classes: {
                            platzkarte: {
                                type: ETrainsCoachType.PLATZKARTE,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 10700,
                                },
                                seats: 94,
                            },
                            compartment: {
                                type: ETrainsCoachType.COMPARTMENT,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 10702,
                                },
                                seats: 35,
                            },
                            suite: {
                                type: ETrainsCoachType.SUITE,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 10230,
                                },
                                seats: 8,
                            },
                        },
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
        {
            id: '2006004-9602494-2021-03-01T10:40-train_9602499-9603162-2021-03-01T15:51-suburban',
            forward: [
                {
                    id: '3423423',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-01T10:40:00Z',
                    arrival: '2021-03-01T14:45:00Z',
                    stationFrom: {
                        id: 2006004,
                        title: 'Ленинградский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9602494,
                        title: 'Московский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 112,
                        title: 'РЖД/ФПК',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        dynamicPricing: {
                            type: ETrainsFeatureType.DYNAMIC_PRICING,
                        },
                        namedTrain: {
                            id: 207,
                            type: ETrainsFeatureType.NAMED_TRAIN,
                            title: 'Невский экспресс',
                            isHighSpeed: true,
                            isDeluxe: false,
                        },
                    },
                    train: {
                        number: 'xc45s',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        classes: {
                            sitting: {
                                type: ETrainsCoachType.SITTING,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 240300,
                                },
                                seats: 275,
                            },
                        },
                    },
                },
                {
                    id: '341223423',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-01T15:51:00Z',
                    arrival: '2021-03-01T19:06:00Z',
                    stationFrom: {
                        id: 9602499,
                        title: 'Ладожский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 2,
                            preposition: 'в',
                            title: 'Санкт-Петербург',
                            titleAccusative: 'Санкт-Петербург',
                            titleGenitive: 'Санкт-Петербурга',
                            titleLocative: 'Санкт-Петербурге',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9603162,
                        title: 'Тихвин',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 10892,
                            preposition: 'в',
                            title: 'Тихвин',
                            titleAccusative: 'Тихвин',
                            titleGenitive: 'Тихвина',
                            titleLocative: 'Тихвине',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 1332,
                        title: 'Северо-западная пригородная пассажирская компания',
                    },
                    features: {
                        subtype: {
                            type: ETrainsFeatureType.SUBTYPE,
                            id: 22,
                            title: '«Ласточка»',
                        },
                    },
                    train: {
                        number: '12mm',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        brokenClassesCode: ETrainsBrokenClassesCode.OTHER,
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
        {
            id: '2000002-9604211-2021-03-01T18:05-train_9604211-9603162-2021-03-02T06:11-train',
            forward: [
                {
                    id: '34234322',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-01T18:05:00Z',
                    arrival: '2021-03-02T05:00:00Z',
                    stationFrom: {
                        id: 2000002,
                        title: 'Ярославский вокзал',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 213,
                            preposition: 'в',
                            title: 'Москва',
                            titleAccusative: 'Москву',
                            titleGenitive: 'Москвы',
                            titleLocative: 'Москве',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9604211,
                        title: 'Череповец-1',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 968,
                            preposition: 'в',
                            title: 'Череповец',
                            titleAccusative: 'Череповец',
                            titleGenitive: 'Череповца',
                            titleLocative: 'Череповце',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 59609,
                        title: 'РЖД/ФПК + ТКС',
                    },
                    features: {
                        eTicket: {
                            type: ETrainsFeatureType.ETICKET,
                        },
                        namedTrain: {
                            id: 172,
                            type: ETrainsFeatureType.NAMED_TRAIN,
                            title: 'Шексна',
                            isHighSpeed: false,
                            isDeluxe: true,
                        },
                    },
                    train: {
                        number: 'sdx1',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        classes: {
                            platzkarte: {
                                type: ETrainsCoachType.PLATZKARTE,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 150820,
                                },
                                seats: 212,
                            },
                            compartment: {
                                type: ETrainsCoachType.COMPARTMENT,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 150812,
                                },
                                seats: 96,
                            },
                            suite: {
                                type: ETrainsCoachType.SUITE,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 150811,
                                },
                                seats: 32,
                            },
                        },
                    },
                },
                {
                    id: '34122342312',
                    duration: 32424,
                    provider: 'P1',
                    departure: '2021-03-02T06:11:00Z',
                    arrival: '2021-03-02T12:02:00Z',
                    stationFrom: {
                        id: 9604211,
                        title: 'Череповец-1',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 968,
                            preposition: 'в',
                            title: 'Череповец',
                            titleAccusative: 'Череповец',
                            titleGenitive: 'Череповца',
                            titleLocative: 'Череповце',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    stationTo: {
                        id: 9603162,
                        title: 'Тихвин',
                        country: {
                            id: 123,
                            code: 'rus',
                        },
                        settlement: {
                            id: 10892,
                            preposition: 'в',
                            title: 'Тихвин',
                            titleAccusative: 'Тихвин',
                            titleGenitive: 'Тихвина',
                            titleLocative: 'Тихвине',
                        },
                        timezone: 'Europe/Moscow',
                    },
                    company: {
                        id: 112,
                        title: 'РЖД/ФПК',
                    },
                    features: {
                        dynamicPricing: {
                            type: ETrainsFeatureType.DYNAMIC_PRICING,
                        },
                    },
                    train: {
                        number: 'ed23',
                        title: 'Москва - Санкт',
                    },
                    tariffs: {
                        classes: {
                            platzkarte: {
                                type: ETrainsCoachType.PLATZKARTE,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 90700,
                                },
                                seats: 29,
                            },
                            compartment: {
                                type: ETrainsCoachType.COMPARTMENT,
                                price: {
                                    currency: CurrencyType.RUB,
                                    value: 12333,
                                },
                                seats: 37,
                            },
                        },
                    },
                },
            ],
            orderUrl: {
                owner: ETrainsVariantUrlOwner.TRAIN,
            },
            backward: [],
        },
    ],
    nearestTrainDatesByDirection: {
        forward: {
            reason: ENearestTrainDatesReason.NO_REQUESTED_DATE_DIRECT_TRAINS,
            dates: [
                {
                    date: '2022-06-20',
                },
                {
                    date: '2022-06-25',
                },
                {
                    date: '2022-07-21',
                },
                {
                    date: '2022-08-10',
                },
                {
                    date: '2022-09-01',
                },
            ],
        },
    },
};
