import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import {ITransformSearchContextRequestParams} from './types/ITransformSearchContextRequestParams';
import {ITransformSearchContextResponse} from './types/ITransformSearchContextResponse';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from '../../getContainerConfig';

export class TransformSearchApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        requestId,
        getApiHost,
        httpClient,
        sendClickHouseStats,
        getServiceTicket,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: `${getApiHost(EApiEntry.TRAVEL)}/komod/cross_search/v1`,
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.serviceTicket = getServiceTicket('travelAPI');
    }

    async transformSearchContext(
        params: ITransformSearchContextRequestParams,
    ): Promise<ITransformSearchContextResponse> {
        const res = await this.get<ITransformSearchContextResponse>(
            '/transform_search_context',
            {
                params,
            },
        );

        // TODO: убрать в TRAVELFRONT-6721
        res.dateForward ||= params.dateForward;
        res.dateBackward ||= params.dateBackward;

        return res;
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.timeout = 2000;
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
            [CommonHeaders.X_YA_USE_CAMELCASE]: 'true',
        };
    }
}
