/* eslint-disable camelcase */

import {EBonusCardType} from 'server/api/TravelersApi/enums/EBonusCardType';

export interface IBonusCardDTO {
    // UUID;
    id: string; // id = fields.UUID(dump_only=True)

    // UUID
    passenger_id: string;

    type: EBonusCardType;

    title: string;

    number: string;

    company_id?: number;

    // format='%Y-%m-%d %H:%M:%S'
    created_at: string;

    // format='%Y-%m-%d %H:%M:%S'
    updated_at: string;
}

export type IBonusCardMutationDTO = Pick<
    IBonusCardDTO,
    'type' | 'title' | 'number' | 'company_id'
>;
