/* eslint-disable camelcase */

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export interface IDocumentDTO {
    // UUID
    id: string;

    // UUID
    passenger_id: string;

    // Тип документа
    type: EDocumentType;

    // Номер документа
    number: string;

    // Псевдоним
    title?: string;

    first_name?: string;

    middle_name?: string;

    last_name?: string;

    first_name_en?: string;

    middle_name_en?: string;

    last_name_en?: string;

    // Дата выпуска документа
    issue_date?: string;

    // Срок истечения действия документа
    // format='%Y-%m-%d'
    expiration_date?: string;

    // GeoId
    citizenship?: number;

    // format='%Y-%m-%d %H:%M:%S'
    created_at: string;

    // format='%Y-%m-%d %H:%M:%S'
    updated_at: string;
}

export type IDocumentMutationDTO = Pick<
    IDocumentDTO,
    | 'type'
    | 'title'
    | 'number'
    | 'first_name'
    | 'middle_name'
    | 'last_name'
    | 'first_name_en'
    | 'middle_name_en'
    | 'last_name_en'
    | 'issue_date'
    | 'expiration_date'
    | 'citizenship'
>;
