/* eslint-disable camelcase */
import {IDocumentDTO} from 'server/api/TravelersApi/types/IDocumentDTO';
import {IBonusCardDTO} from 'server/api/TravelersApi/types/IBonusCardDTO';
import {EGender} from 'types/common/document/EGender';

export interface IPassengerDTO {
    // UUID
    id: string;

    // Псевдоним пассажира
    title: string;

    gender: EGender;

    // Дата рождения пассажира
    // format='%Y-%m-%d'
    birth_date: string;

    phone: string | null;

    phone_additional: string | null;

    email: string | null;

    train_notifications_enabled: boolean;

    // format='%Y-%m-%d %H:%M:%S'
    created_at: string;

    // format='%Y-%m-%d %H:%M:%S'
    updated_at: string;
}

export interface IPassengerWithDocumentsDTO extends IPassengerDTO {
    documents: IDocumentDTO[];
}

export interface IPassengerWithBonusCardsDTO extends IPassengerDTO {
    bonus_cards: IBonusCardDTO[];
}

export interface IPassengerWithDocumentsAndBonusCardsDTO extends IPassengerDTO {
    bonus_cards: IBonusCardDTO[];
    documents: IDocumentDTO[];
    itn: string | null;
}

export type TPassengerMutationDTO = Pick<
    IPassengerDTO,
    'title' | 'gender' | 'birth_date'
> &
    Partial<
        Pick<
            IPassengerDTO,
            | 'phone'
            | 'phone_additional'
            | 'email'
            | 'train_notifications_enabled'
        >
    >;

export interface IPassengerMergeDTO extends TPassengerMutationDTO {
    // UUID[]
    passengers: string[];
}
