import times from 'lodash/times';

import ITripForecast from 'types/trips/ITripForecast/ITripForecast';

export function getForecast(forecastCount: number | undefined): ITripForecast {
    const exactForecastYandexWeatherUrl =
        'https://yandex.ru/pogoda/?lat=59.93909836&lon=30.31587601';
    const summaryForecastYandexWeatherUrl =
        'https://yandex.ru/pogoda/month?lat=59.93909836&lon=30.31587601&via=hnav';

    const items = [
        {
            imageUrl:
                'https://yastatic.net/weather/i/icons/funky/dark/bkn_ra_d.svg',
            title: 'вт, 24 ноя',
            description: '+10...8°',
            url: exactForecastYandexWeatherUrl,
        },
        {
            imageUrl:
                'https://yastatic.net/weather/i/icons/funky/dark/skc_d.svg',
            title: 'ср, 25 ноя',
            description: '+10...8°',
            url: exactForecastYandexWeatherUrl,
        },
        {
            imageUrl:
                'https://yastatic.net/weather/i/icons/funky/dark/bkn_d.svg',
            title: 'чт, 26 ноя',
            description: '+10...8°',
            url: exactForecastYandexWeatherUrl,
        },
        {
            imageUrl: 'https://yastatic.net/weather/i/icons/funky/dark/ovc.svg',
            title: 'пт, 27 ноя',
            description: '+10...8°',
            url: exactForecastYandexWeatherUrl,
        },
        {
            imageUrl:
                'https://yastatic.net/weather/i/icons/funky/dark/ovc_ra.svg',
            title: 'Обычно в ноябре +8...10°',
            description: '8 дней с осадками',
            url: summaryForecastYandexWeatherUrl,
        },
    ];

    if (typeof forecastCount === 'number') {
        return {
            items: [
                ...items.slice(0, forecastCount),
                ...times(forecastCount - items.length).map(() => items[0]),
            ],
        };
    }

    return {
        items,
    };
}
