import IGetMoreTripsApiResponse from 'server/api/TripsApi/types/IGetMoreTripsApiResponse';
import TTripListItem from 'types/trips/TTripListItem/TTripListItem';
import {ETripListItemType} from 'types/trips/ETripListItemType';
import ETripState from 'types/trips/ETripState';

const pastTrips: TTripListItem[] = [
    {
        type: ETripListItemType.REAL,
        id: '10',
        title: 'Казань',
        image: 'https://avatars.mds.yandex.net/get-travel-hotels/2000187/region_image_43_0/region-desktop',
        displayDate: '24 фев — 4 мар, 2021',
        state: ETripState.CONFIRMED,
    },
    {
        type: ETripListItemType.REAL,
        id: '11',
        title: 'Ростов-на-Дону',
        image: 'https://avatars.mds.yandex.net/get-travel-hotels/2409838/region_image_39_0/region-desktop',
        displayDate: '1 — 10 янв, 2021',
        state: ETripState.CANCELLED,
    },
];

const trips: IGetMoreTripsApiResponse = {
    active: {
        trips: [],
        continuationToken: null,
    },
    past: {
        trips: pastTrips,
        continuationToken: null,
    },
};

export default trips;
