import moment from 'moment';

import ITripAviaCheckInNotification from 'types/trips/ITripNotifications/TTripNotification/ITripAviaCheckInNotification/ITripAviaCheckInNotification';
import ETripNotificationType from 'types/trips/ITripNotifications/ETripNotificationType';
import ITripHotelDeferredPaymentNotification from 'types/trips/ITripNotifications/TTripNotification/ITripHotelDeferredPaymentNotification/ITripHotelDeferredPaymentNotification';
import ETripOrderState from 'types/trips/ETripOrderState';

import mockAirlines from 'server/api/TripsApi/__mocks__/mockAirlines';

export function getAviaCheckInNotification(): ITripAviaCheckInNotification {
    return {
        type: ETripNotificationType.AVIA_CHECK_IN,
        orderId: '1',
        airline: mockAirlines.aeroflot,
        flightTitle: 'Екатеринбург — Санкт-Петербург',
        flightNumber: 'SU 1418',
        offlineCheckIn: {
            checkInCounters: '112',
            gate: '16',
        },
        registrationUrl: 'https://www.aeroflot.ru/sb/ckin/app/ru-ru',
        pnr: 'VJA91',
        updatedAt: moment().add(-1, 'minute').format(),
    };
}

export function getHotelDeferredPaymentNotification(): ITripHotelDeferredPaymentNotification {
    return {
        type: ETripNotificationType.HOTEL_DEFERRED_PAYMENT,
        order: {
            id: '10',
            title: 'Друзья на Банковском',
            image: 'https://avatars.mds.yandex.net/get-altay/941278/2a0000016156f0a59a6509c7e500386f7f0b/M',
            displayCheckinCheckoutDates: '24 ноя — 24 дек',
            address: 'Санкт-Петербург, площадь Александра Невского, 2',
            coordinates: {lon: 37.85804, lat: 55.549389},
            state: ETripOrderState.CONFIRMED,
        },
    };
}
