import shuffle from 'lodash/shuffle';

import IGetTripAsyncBlocksResponse from 'server/api/TripsApi/types/IGetTripAsyncBlocksResponse';
import ETripBlockType from 'types/trips/ETripBlockType';
import ETripActivityType from 'types/trips/ITripActivities/ETripActivityType';
import {
    ITripAfishaActivity,
    ITripIziTravelActivity,
} from 'types/trips/ITripActivities/TTripActivity';

import iziTravelTours from 'server/api/TripsApi/__mocks__/iziTravelTours';
import afishaEvents from 'server/api/TripsApi/__mocks__/afishaEvents';

interface ICreateTripAsyncBlocksParams {
    mockActivityTypes: ETripActivityType[];
}

export default function createTripAsyncBlocks({
    mockActivityTypes,
}: ICreateTripAsyncBlocksParams): IGetTripAsyncBlocksResponse {
    const activities = shuffle([
        ...iziTravelTours.map(
            (tour): ITripIziTravelActivity => ({
                type: ETripActivityType.IZI_TRAVEL,
                payload: tour,
            }),
        ),
        ...afishaEvents.map(
            (event): ITripAfishaActivity => ({
                type: ETripActivityType.AFISHA,
                payload: event,
            }),
        ),
    ]).filter(activity => mockActivityTypes.includes(activity.type));

    return {
        blocks: [
            {
                type: ETripBlockType.ACTIVITIES,
                isLoaded: true,
                block: {
                    activities,
                },
            },
        ],
    };
}
