import ETripActivityType, {
    isTripActivityType,
} from 'types/trips/ITripActivities/ETripActivityType';

export default function parseActivityTypesFromJSON(
    cookieValue: string | undefined,
): ETripActivityType[] {
    if (!cookieValue) {
        return Object.values(ETripActivityType);
    }

    try {
        const arr = JSON.parse(cookieValue);

        return arr.filter(isTripActivityType);
    } catch (e) {
        return [];
    }
}
