import ETripNotificationType, {
    isTripNotificationType,
} from 'types/trips/ITripNotifications/ETripNotificationType';

export default function parseNotificationsFromJSON(
    cookieValue: string | undefined,
): ETripNotificationType[] {
    if (!cookieValue) {
        return [];
    }

    try {
        const arr = JSON.parse(cookieValue);

        return arr.filter(isTripNotificationType);
    } catch (e) {
        return [];
    }
}
