import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import {IGetForecastByGeoIdParams} from 'server/api/WeatherApi/types/IGetForecastByGeoIdParams';
import {IGetForecastByGeoIdResponse} from 'server/api/WeatherApi/types/IGetForecastByGeoIdResponse';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

export class WeatherApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        requestId,
        getApiHost,
        httpClient,
        sendClickHouseStats,
        getServiceTicket,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: `${getApiHost(EApiEntry.TRAVEL)}/weather`,
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.serviceTicket = getServiceTicket('travelAPI');
    }

    getWeatherForecastByGeoId(
        params: IGetForecastByGeoIdParams,
    ): Promise<IGetForecastByGeoIdResponse> {
        return this.get('/v1/get_by_geo_id', {params});
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.timeout = 25000;
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
            [CommonHeaders.X_YA_USE_CAMELCASE]: 'true',
        };
    }
}
