import 'core-js/stable';
import getContainerConfig from 'server/getContainerConfig';

import weatherApiController from './controllers/weatherApiController';
import aviaApiController from './controllers/aviaApiContoller';
import trainsApiController from './controllers/trainsApiController';
import commonApiController from './controllers/commonApiController';
import hotelsApiController from './controllers/hotelsApiController';
import hotelsExtranetApiController from './controllers/hotelsExtranetApiController';
import busesApiController from './controllers/busesApiController';
import accountApiController from './controllers/accountApiController';
import ordersApiController from './controllers/ordersApiController';
import genericOrdersApiController from './controllers/genericOrderApiController';
import bunkerApiContoller from './controllers/bunkerApiContoller';
import personalizationController from './controllers/personalizationController';
import tripsApiController from './controllers/tripsApiController';
import templatorApiController from './controllers/templatorApiController';
import crossSearchApiController from './controllers/crossSearchApiController';
import reviewsController from './controllers/reviewsController';
import toursApiController from './controllers/toursApiController';
import levelTravelController from './controllers/levelTravelApiController';
import notebookApiController from './controllers/notebookApiController';
import testControlPanelController from './controllers/testControlPanelController';

const config = require('../.config');

const projectApiControllerByType = {
    avia: aviaApiController,
    trains: trainsApiController,
    common: commonApiController,
    hotels: hotelsApiController,
    hotelsExtranet: hotelsExtranetApiController,
    buses: busesApiController,
    account: accountApiController,
    orders: ordersApiController,
    genericOrder: genericOrdersApiController,
    bunker: bunkerApiContoller,
    personalization: personalizationController,
    trips: tripsApiController,
    templator: templatorApiController,
    crossSearch: crossSearchApiController,
    reviews: reviewsController,
    tours: toursApiController,
    levelTravel: levelTravelController,
    notebook: notebookApiController,
    weather: weatherApiController,
    '-': commonApiController.restoreTinyUrl,
    ...(config.env === 'production'
        ? {}
        : {testControlPanel: testControlPanelController}),
};

function registerContainer(req, res) {
    req.container.register(getContainerConfig(req, res, {isSSR: false}));
}

export default () => (req, resp) => {
    const {params} = req;
    const {project, action, param} = params;
    const projectController = projectApiControllerByType[project];

    let projectAction;

    if (typeof projectController === 'function') {
        projectAction = projectController;
    } else if (projectController) {
        if (param) {
            projectAction =
                projectController[action] && projectController[action][param];
        } else {
            projectAction = projectController[action];
        }

        if (typeof projectAction !== 'function') {
            projectAction = projectController['*'];
        }
    }

    if (typeof projectAction === 'function') {
        registerContainer(req, resp);

        projectAction(req, resp);
    } else {
        resp.status(404).send();
    }
};
