const {csp} = require('@yandex-data-ui/core');

const {clickhouseHost, clickhousePort} = require('./constants/clickhouse');

const {
    AVIA_USER_SEARCH_LOG_NAME,
    AVIA_REDIRECT_LOG_NAME,
    AVIA_REDIRECT_ERROR_LOG_NAME,
    AVIA_SHOW_LOG_NAME,
    AVIA_ACTION_LOG_NAME,
    AVIA_POPULAR_FLIGHT_LOG_NAME,
    AVIA_REDIRECT_SHOW_LOG_NAME,
    AVIA_LANDING_VISIT_LOG_NAME,
} = require('../loggers/avia/utils/aviaLoggerConstants');

const getVersion = require('../../tools/version');
const commonCspPresets = require('./csp/presets/common');
const testingCspPresets = require('./csp/presets/testing');
const productionCspPresets = require('./csp/presets/production');

const version = getVersion();

function getLogConfig(fileName, type) {
    return {
        path: `/ephemeral/var/log/frontend/avia/${fileName}.log`,
        type,
    };
}

const CSP_YANDEX = 'yandex.ru';
const CSP_YANDEX_DOMAINS = '*.yandex.ru:*';
const CSP_YANDEX_COM_DOMAINS = '*.yandex.com';
const CSP_IFRAME_TOLOKA = 'iframe-toloka.com';
const CSP_SANDBOX_IFRAME_TOLOKA = 'sandbox.iframe-toloka.com';
const CSP_YAPIC = 'yapic.yandex.ru';
const CSP_IMG_YANDEX_RU = 'img.yandex.ru';
const CSP_YMAPS_STATIC = 'static-maps.yandex.ru';
const CSP_YMAPS_API = 'api-maps.yandex.ru';
const CSP_CLCK = 'clck.yandex.ru';
const CSP_AEROFLOT = 'pay.test.aeroflot.ru';
const CSP_RBSUAT = 'web.rbsuat.com';
const CSP_I_TRAVEL = 'i.travelapi.com';
const CSP_DELFINCHIK = 'http://ppt.delfinchik.net';
const CSP_YANDEX_COUNTERS = 'https://yandex.ru/clck/click';
const CSP_TEST_NET_URL = 'https://travel-test.yandex.net';
const CSP_NET_URL = 'https://travel.yandex.net';
const CSP_3DS_TEST_URL = 'https://3ds.travel-test.yandex-net.ru';
const CSP_3DS_PRESTABLE_URL = 'https://3ds.travel-prestable.yandex-net.ru';
const CSP_3DS_URL = 'https://3ds.travel.yandex.net';
const CSP_YASTAT = 'yastat.net';
const CSP_YASTATIC = 'yastatic.net';
const CSP_YANDEX_CHAT_NET = 'chat.s3.yandex.net';
const CSP_YANDEX_MDS = 's3.mds.yandex.net';
const CSP_MAIL = 'https://mail.yandex.ru';
const CSP_TRAVELLINE = [
    'www.qatl.ru',
    'www.travelline.ru',
    'secure.travelline.pro',
    'secure.travelline.ru',
];
const CSP_BNOVO = 'https://reservationsteps.ru/files/';
const CSP_BRONEVIK_TEST = 'dev.bronevik.tech';
const CSP_BUG_PRESET = [
    'https://yandex.ru/ecoo/testids/suggest',
    'https://yandex.ru/ecoo/sign',
    'https://yandex.ru/ecoo/clean',
    'https://yandex.ru/ecoo/check',
];
const CSP_IZI_TRAVEL = 'http://media.izi.travel';
const CSP_YANDEX_MARKET = 'aflt.market.yandex.ru';
const CSP_YANDEX_LEVEL_TRAVEL = 'yandex.level.travel';
const CSP_YSA_STATIC = 'https://ysa-static.passport.yandex.ru/static/'; // Используется в виджете Яндекс.Маркета
const CLICKHOUSE_TABLE_CONFIG = {
    service: 'string',
    responseStatus: 'number',
    requestId: 'string',
    requestTime: 'number',
    requestMethod: 'string',
    requestUrl: 'string',
    timestamp: 'number',
};

module.exports = {
    version,
    csp: {
        /*
         * Когда баг с prefetch-src пофиксится, переместить CSP_YASTAT в prefetch-src
         *
         * @see https://bugs.chromium.org/p/chromium/issues/detail?id=801561
         */
        'default-src': [csp.BLOB, CSP_YASTAT, CSP_YASTATIC],
        'script-src': [
            CSP_YANDEX,
            CSP_YASTAT,
            CSP_YASTATIC,
            CSP_YANDEX_MARKET,
            CSP_YANDEX_CHAT_NET,
        ],
        'style-src': [CSP_YASTAT, CSP_YASTATIC],
        'img-src': [
            csp.BLOB,
            CSP_CLCK,
            CSP_YAPIC,
            CSP_IMG_YANDEX_RU,
            CSP_I_TRAVEL,
            CSP_YANDEX_COUNTERS,
            CSP_YASTAT,
            CSP_YASTATIC,
            CSP_DELFINCHIK,
            ...CSP_TRAVELLINE,
            CSP_BNOVO,
            CSP_YMAPS_STATIC,
            CSP_IZI_TRAVEL,
            CSP_YSA_STATIC,
            CSP_BRONEVIK_TEST,
        ],
        'media-src': [csp.BLOB],
        'connect-src': [
            CSP_YANDEX_COUNTERS,
            CSP_YASTAT,
            CSP_YASTATIC,
            CSP_MAIL,
            CSP_YMAPS_API,
            CSP_YANDEX_MARKET,
            CSP_YANDEX_LEVEL_TRAVEL,
            ...CSP_BUG_PRESET,
        ],
        'frame-src': [
            csp.BLOB,
            CSP_YANDEX,
            CSP_AEROFLOT,
            CSP_RBSUAT,
            CSP_3DS_URL,
            CSP_3DS_PRESTABLE_URL,
            CSP_3DS_TEST_URL,
            CSP_TEST_NET_URL,
            CSP_NET_URL,
            CSP_YASTAT,
            CSP_YASTATIC,
            CSP_YANDEX_MDS,
        ],
        'frame-ancestors': [
            CSP_3DS_URL,
            CSP_3DS_PRESTABLE_URL,
            CSP_3DS_TEST_URL,
            CSP_YANDEX,
            CSP_YANDEX_DOMAINS,
            CSP_YANDEX_COM_DOMAINS,
            CSP_IFRAME_TOLOKA,
            CSP_SANDBOX_IFRAME_TOLOKA,
        ],
        'font-src': [CSP_YASTAT, CSP_YASTATIC],
    },
    cspPresets: [
        ...commonCspPresets,
        ...testingCspPresets,
        ...productionCspPresets,
    ],
    authPolicy: 'optional',
    passport: {
        blackbox: {
            attributes: {login: '1008', lang: '34', plus: '1015'},
            fields: {
                yandexoid: 'subscription.login.669',
                betatest: 'subscription.login.668',
            },
        },
    },
    static: {
        provider: 'https://yastatic.net/s3/travel/',
        staticPath: `static/client/${version}/`,
        freezePath: 'static/_/',
    },
    uaasExperiments: {
        trainsHideAdsSerp: 'TRAINS_hide_ads_serp:test',
        hotelsTopSnippet: 'HOTELS_snippet:enabled',
        passToMetricHotelsSearchPageSearchtime:
            'HOTELS_pass_searchtime:enabled',
        trainsNewTrustForm: 'TRAINS_new_form:enabled',
        hotelsPreviousSearches: 'HOTELS_previous_searches:enabled',
        aviaAeroflotPlus: 'avia_aeroflot_plus:enabled',
        hotelsNewTrustForm: 'HOTELS_new_form:enabled',
        trainsOnlyDirect: 'TRAINS_only_direct:enabled',
        trainsScrollToPassengersStep:
            'TRAINS_scroll_to_passengers_step:enabled',
        trainsDisableCoachTypeTabs: 'TRAINS_disable_coach_type_tabs:enabled',
        trainsDefaultActiveTab: 'TRAINS_default_active_tab:enabled',
        trainsNearestTrainDates: 'TRAINS_nearestTrainDates:enabled',
        aviaSearchToAnywherePage: 'avia_search_to_anywhere_page:enabled',
        aviaNewTrustForm: 'avia_boy_new_trust:enabled',
        roomsMatching: 'HOTELS_rooms_matching:enabled',
        newDatePickerEnabled: 'TRAVEL_new_datepicker:enabled',
        priceAfterPlusWithdrawTop: 'MARKETING_price_after_plus_withdraw:top',
        priceAfterPlusWithdrawBottom:
            'MARKETING_price_after_plus_withdraw:bottom',
        hotelsPercentDiscount: 'HOTELS_percent:enabled',
        trainsSearchHotelsCrossSaleEnabled:
            'KOMOD_trains_search_hotels_cross_sale:enabled',
        aviaSearchLowerCrossSaleEnabled:
            'KOMOD_avia_search_lower_cross_sale:enabled',
        aviaCleanSerpEnabled: 'KOMOD_avia_clean_serp:enabled',
        trainsCleanSerpEnabled: 'KOMOD_trains_clean_serp:enabled',
        hotelsCleanSerpEnabled: 'KOMOD_hotels_clean_serp:enabled',
        hotelsRegionPageFilter: 'HOTELS_filter_block:enabled',
        tabBarEnabled: 'KOMOD_tab_bar:enabled',
        hotelsSwitchWithAvia: 'HOTELS_switch_with_avia:enabled',
        aviaNewTouchFilters: 'avia_new_touch_filters:enabled',
        aviaTariffChangingCarriageEnabled:
            'AVIA_tariff_changing_carriage:enabled',
        aviaTariffHideFlight: 'AVIA_tariff_hide_flight:enabled',
        aviaTariffMoveCardTop: 'AVIA_tariff_move_card_top:enabled',
        aviaTariffFlightInfoAccordion:
            'AVIA_tariff_flight_info_accordion:enabled',
        aviaTariffCardClickOpenOrderPage:
            'AVIA_tariff_card_click_open_order_page:enabled',
        aviaTariffCardClickOpenTariffSheet:
            'AVIA_tariff_card_click_open_tariff_sheet:enabled',
        aviaSearchButtonTextInside: 'avia_search_button_text_inside:enabled',
        aviaSearchButtonTextOutside: 'avia_search_button_text_outside:enabled',
        aviaSearchButtonTextOutsideSelect:
            'avia_search_button_text_outside:select',
        hotelsFeaturesDown: 'HOTELS_hotelpage_features_down2:enabled',
        hotelsHideFeatures: 'HOTELS_hidefeatures:enabled',
        aviaDefaultSortPrice: 'avia_default_sort:price',
        hotelsHotelsPageMapTransport: 'HOTELS_hotelpage_map_transport:enabled',
        organicAviaDynamicMinPrice: 'ORGANIC_avia_dynamic_min_price:enabled',
        organicAviaDynamicWeek: 'ORGANIC_avia_dynamic_week:enabled',
        aviaWeatherDesktop: 'avia_weather_desktop:enabled',
        aviaOnlyWeatherRight: 'avia_only_weather_right:enabled',
        aviaOnlyHotelsRight: 'avia_only_hotels_right:enabled',
        aviaHotelsThenWeatherRight: 'avia_hotels_then_weather_right:enabled',
        hotelsCalendarPrices: 'HOTELS_calendarPrices:enabled',
        rebrandingSubscriptions: 'rebranding_subscriptions:enabled',
        hotelsGeoFilter: 'HOTELS_moskowarea:enabled',
        hotelsFiltersCurtain: 'HOTELS_touchfilters_curtain:enabled',
        hotelsFiltersSheet: 'HOTELS_touchfilters_sheet:enabled',
        ampPagesEnabled: 'ORGANIC_amp_pages:enabled',
        darkThemeEnabled: 'dark-theme:enabled',
        hideMorePlusPointsOnRegionPage: 'morePlusPointsOnRegionPage:hide',
    },
    experiments: {
        // Common

        // Trains
        skipSalesCheck: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },
        trainsAllowInternationalRoutes: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },

        // Avia
        isAviaPortal: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },

        // Hotels
        hotelsBookPage: {
            type: Boolean,
            defaultValue: false,
            denied: true,
        },
    },
    features: {
        enableFeaturesPage: false,
    },
    s3storage: {
        accountBucket: 'account-order-search',
    },
    cookieSession: {
        secret: 'COOKIE_SESSION_SECRET',
    },
    telemetryChHost: clickhouseHost,
    telemetryChPort: clickhousePort,
    telemetryChDatabase: 'api_logs',
    telemetryChAuth: process.env.TELEMETRY_CLICKHOUSE_CREDENTIALS,
    telemetryChTables: {
        env_testing: CLICKHOUSE_TABLE_CONFIG,
        env_production: CLICKHOUSE_TABLE_CONFIG,
    },
    telemetryChBatchSize: 500,
    avia: {
        // названия партнеров добавляются строго через запятую без пробелов
        notInstantPartners: process.env.AVIA_NOT_INSTANT_PARTNERS,
    },
    fileLogging: {
        avia: {
            [AVIA_REDIRECT_LOG_NAME]: getLogConfig('json_redir'),
            [AVIA_REDIRECT_ERROR_LOG_NAME]: getLogConfig(
                'redirect_error',
                'avia-redirect-error-log',
            ),
            [AVIA_USER_SEARCH_LOG_NAME]: getLogConfig('json_user-search'),
            [AVIA_SHOW_LOG_NAME]: getLogConfig('json_action-show'),
            [AVIA_ACTION_LOG_NAME]: getLogConfig('json_action'),
            [AVIA_POPULAR_FLIGHT_LOG_NAME]: getLogConfig(
                'popular_flights',
                'rasp-popular-flights-log',
            ),
            [AVIA_REDIRECT_SHOW_LOG_NAME]: getLogConfig(
                'show',
                'avia-show-log',
            ),
            [AVIA_LANDING_VISIT_LOG_NAME]: getLogConfig(
                'json_users-visit-landing',
            ),
        },
    },
    nationalSettings: {
        default: {
            nationalCurrency: 'RUR',
            allowedCurrencies: ['RUR'],
        },
        ru: {
            nationalCurrency: 'RUR',
            allowedCurrencies: ['RUR', 'USD', 'EUR', 'KZT'],
        },
    },
    domainToNationalVersion: {
        ru: 'ru',
        ua: 'ua',
        'com.tr': 'tr',
        com: 'com',
        kz: 'kz',
    },
    webvisor: {
        inclusionPercent: {
            projects: {},
            defaultPercent: 1,
        },
    },
    disableIncompatible: true,
};
