const {csp} = require('@yandex-data-ui/core');

/** https://docs.yandex-team.ru/cmnt/cookbook/init_ya_cmnt#shag-1.-nastroit-csp */
module.exports = (env = 'production') => {
    const isProduction = env === 'production';

    const betaStaticUrls = isProduction ? [] : ['betastatic.yastatic.net'];
    const filesUrl = isProduction
        ? 'files.messenger.yandex.net'
        : 'files.messenger.alpha.yandex.net';
    const commentsUrls = isProduction
        ? [`*.comments.yandex.${csp.TLD}`, 'wss://comments.yandex.net']
        : [
              `*.comments-alpha.yandex.${csp.TLD}`,
              'wss://comments-alpha.yandex.net',
          ];

    const wholeYandexDotNet = '*.yandex.net';
    const frameUrls = [csp.SELF, `passport.yandex.${csp.TLD}`];
    const connectUrls = [
        `yandex.${csp.TLD}`,
        `api.passport.yandex.${csp.TLD}`,
        filesUrl,
        ...commentsUrls,
    ];

    if (!isProduction) {
        connectUrls.push(`l7test.yandex.${csp.TLD}`);
    }

    const avatars = csp.avatars('production');
    const yaStat = csp.yastat(env, [csp.SCRIPT, csp.STYLE]);
    const yaStatic = csp.yaStatic([csp.SCRIPT, csp.STYLE]);

    return {
        [csp.CONNECT]: connectUrls,
        [csp.SCRIPT]: [
            ...yaStat[csp.SCRIPT],
            ...yaStatic[csp.SCRIPT],
            ...betaStaticUrls,
        ],
        [csp.STYLE]: [
            ...yaStat[csp.STYLE],
            ...yaStatic[csp.STYLE],
            ...betaStaticUrls,
        ],
        [csp.IMG]: [csp.DATA, filesUrl, ...avatars[csp.IMG], wholeYandexDotNet],
        [csp.FRAME]: frameUrls,
    };
};
