const path = require('path');

const {DATAUI_TVM_DEV_OPTIONS} = require('../constants/common');

const {
    AVIA_USER_SEARCH_LOG_NAME,
    AVIA_REDIRECT_LOG_NAME,
    AVIA_REDIRECT_ERROR_LOG_NAME,
    AVIA_SHOW_LOG_NAME,
    AVIA_ACTION_LOG_NAME,
    AVIA_POPULAR_FLIGHT_LOG_NAME,
    AVIA_REDIRECT_SHOW_LOG_NAME,
    AVIA_LANDING_VISIT_LOG_NAME,
} = require('../loggers/avia/utils/aviaLoggerConstants');
const envify = require('../utilities/envify');

function getLogConfig(fileName, type) {
    return {
        path: path.join(
            __dirname,
            '../..',
            `log/frontend/avia/${fileName}.log`,
        ),
        type,
    };
}

module.exports = {
    port: process.env.DEV_PORT || 9000,
    adFox: {
        ownerId: 357839,
        siteId: 'ejlu',
    },
    passport: {
        blackbox: {
            api: 'pass-test.yandex.ru',
            emails: 'getdefault',
            getphones: 'bound',
            phone_attributes: '1',
            multisession: 'yes',
            attributes: {login: '1008', lang: '34', plus: '1015'},
            fields: {
                yandexoid: 'subscription.login.669',
                betatest: 'subscription.login.668',
            },
        },
        avatarPath: 'https://avatars.mdst.yandex.net/',
        passportPath: 'https://passport-test.yandex.ru',
        authorizePath:
            'https://passport-test.yandex.ru/passport?mode=auth&retpath=',
        resignPath: 'https://passport-test.yandex.ru/auth/update?&retpath=',
    },
    environmentConfig: {
        secureIFramePath: '/3ds',
        uxfeedbackIframeSrc: '/webpackStatic/uxfeedback.html',
    },
    static: {
        provider: '/',
        staticPath: 'webpackStatic/',
        freezePath: 'webpackStatic/',
    },
    ...DATAUI_TVM_DEV_OPTIONS,
    servicesAPI: envify('BASE_URL_', {
        travel: 'https://api.travel-balancer-test.yandex.net/api',
        aviaFront: 'https://front.avia.tst.yandex.ru/epp-api',
        avia: 'https://api.avia.tst.yandex.net',
        aviaGateway: 'http://api-gateway.testing.avia.yandex.net/v1',
        flightStorage: 'http://api-gateway.testing.avia.yandex.net/v1/flight',
        trains: 'https://testing.train-api.rasp.internal.yandex.net',
        geoBase: 'http://geobase-test.qloud.yandex.ru',
        uatraits: 'http://uatraits-test.qloud.yandex.ru',
        travellers: 'https://travelers.testing.avia.yandex.net',
        rasp: 'https://testing.morda-backend.rasp.yandex.net',
        raspCache:
            'https://testing.http-proxy-cache.internal.rasp.yandex.net/morda_backend',
        raspSuggests: 'https://testing.suggests.rasp.common.yandex.net',
        trainsOfferStorage:
            'https://testing.offer-storage.internal.rasp.yandex.net',
        aviaBookingOrders: 'http://booking-service.testing.avia.yandex.net',
        passengerExperience:
            'http://api-gateway.testing.avia.yandex.net/v1/flight-extras',
        aviaTicketDaemon:
            'http://api-gateway.testing.avia.yandex.net/v1/ticket-daemon-api',
        aviaBackend: 'http://backend.testing.avia.yandex.net',
        aviaSuggests: 'https://suggests.avia.tst.yandex.net',
        aviaPriceIndex:
            'http://api-gateway.testing.avia.yandex.net/v1/price-index/',
        aviaFeatures:
            'http://api-gateway.testing.avia.yandex.net/v1/avia-features',
        tinyUrl: 'http://tinyurl-test.yandex.ru/tiny',
        busesGeo: 'https://testing.geo-api.internal.bus.yandex.net',
        buses: 'https://testing.backend.internal.bus.yandex.net/api',
        bunker: 'http://bunker-api-dot.yandex.net',
        imageGenerator: 'https://travel-tools-test.yandex.net/image-generator',
        templator: 'http://templator.vs.market.yandex.net:29338/tarantino',
        reviews: 'https://rasp.s3.yandex.net/reviews',
        levelTravel: 'https://api.level.travel',
        hotelsExtranet:
            'https://api.travel-balancer-test.yandex.net/api/hotels_extranet',
    }),
    experiments: {
        // Common

        // Trains
        skipSalesCheck: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },
        trainsAllowInternationalRoutes: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },

        // Avia
        enablePartnersFilter: {
            type: Boolean,
            defaultValue: true,
            denied: false,
        },
        isAviaPortal: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },

        // Hotels
        enableDebugHotelProdOffers: {
            type: Boolean,
            defaultValue: true,
            denied: false,
        },
    },
    features: {
        enableFeaturesPage: true,
    },
    orders: {
        canUseMockPayment: true,
        canUseTestContext: true,
    },
    uaas: {
        uri: 'http://uaas.search.yandex.net/travel',
        handler: 'TRAVEL',
        env: 'testing',
    },
    csrf: {
        secret: 'CSRF_DEV_TOKEN',
        lifetime: 7 * 24 * 60 * 60,
    },
    fileLogging:
        process.env.TRAVEL_LOG_AVIA === '1'
            ? {
                  avia: {
                      [AVIA_REDIRECT_LOG_NAME]: getLogConfig('json_redir'),
                      [AVIA_REDIRECT_ERROR_LOG_NAME]: getLogConfig(
                          'redirect_error',
                          'avia-redirect-error-log',
                      ),
                      [AVIA_USER_SEARCH_LOG_NAME]:
                          getLogConfig('json_user-search'),
                      [AVIA_SHOW_LOG_NAME]: getLogConfig('json_action-show'),
                      [AVIA_ACTION_LOG_NAME]: getLogConfig('json_action'),
                      [AVIA_POPULAR_FLIGHT_LOG_NAME]: getLogConfig(
                          'popular_flights',
                          'rasp-popular-flights-log',
                      ),
                      [AVIA_REDIRECT_SHOW_LOG_NAME]: getLogConfig(
                          'show',
                          'avia-show-log',
                      ),
                      [AVIA_LANDING_VISIT_LOG_NAME]: getLogConfig(
                          'json_users-visit-landing',
                      ),
                  },
              }
            : null,
    travelTracing: {
        config: {
            /**
             * @see https://www.jaegertracing.io/docs/1.13/getting-started/#all-in-one
             */
            serviceName: 'travel-front',
            disable: true,
            sampler: {
                type: 'const',
                param: 1,
            },
        },
        options: {
            logger: console,
        },
        meta: {
            forceDebugTag: true,
        },
    },
};
