const {resolve} = require('path');

const envify = require('../utilities/envify');

module.exports = {
    socket: resolve(__dirname, '../run/node.sock'),
    adFox: {
        ownerId: 357839,
        siteId: 'eivq',
    },
    passport: {
        blackbox: {
            api: 'blackbox.yandex.net',
            emails: 'getdefault',
            getphones: 'bound',
            phone_attributes: '1',
            multisession: 'yes',
            attributes: {login: '1008', lang: '34', plus: '1015'},
            fields: {
                yandexoid: 'subscription.login.669',
                betatest: 'subscription.login.668',
            },
        },
        avatarPath: 'https://avatars.mds.yandex.net/',
        passportPath: 'https://passport.yandex.ru',
        authorizePath: 'https://passport.yandex.ru/passport?mode=auth&retpath=',
        resignPath: 'https://passport.yandex.ru/auth/update?&retpath=',
    },
    environmentConfig: {
        secureIFramePath: 'https://3ds.travel.yandex.net/3ds',
        uxfeedbackIframeSrc:
            'https://yastatic.net/s3/travel/static/_/uxfeedback.html',
    },
    servicesAPI: envify('BASE_URL_', {
        travel: 'https://api-prod.travel-hotels.yandex.net/api',
        aviaFront: 'https://avia.yandex.ru/epp-api',
        avia: 'https://api.avia.yandex.net',
        aviaGateway: 'http://api-gateway.production.avia.yandex.net/v1',
        flightStorage:
            'http://api-gateway.production.avia.yandex.net/v1/flight',
        trains: 'https://production.train-api.rasp.internal.yandex.net',
        geoBase: 'http://geobase.qloud.yandex.ru',
        uatraits: 'http://uatraits.qloud.yandex.ru',
        travellers: 'https://travelers.production.avia.yandex.net',
        rasp: 'https://morda-backend.rasp.yandex.net',
        raspCache:
            'https://production.http-proxy-cache.internal.rasp.yandex.net/morda_backend',
        raspSuggests: 'https://suggests.rasp.yandex.net',
        trainsOfferStorage:
            'https://production.offer-storage.internal.rasp.yandex.net',
        aviaBookingOrders: 'http://booking-service.production.avia.yandex.net',
        passengerExperience:
            'http://api-gateway.production.avia.yandex.net/v1/flight-extras',
        aviaTicketDaemon:
            'http://api-gateway.production.avia.yandex.net/v1/ticket-daemon-api',
        aviaBackend: 'http://backend.production.avia.yandex.net',
        aviaSuggests: 'https://suggests.avia.yandex.ru',
        aviaPriceIndex:
            'http://api-gateway.production.avia.yandex.net/v1/price-index/',
        aviaFeatures:
            'http://api-gateway.production.avia.yandex.net/v1/avia-features',
        tinyUrl: 'http://tinyurl.yandex.net/tiny',
        busesGeo: 'https://geo-api.bus.yandex.net',
        buses: 'https://backend.internal.bus.yandex.net/api',
        bunker: 'http://bunker-api.yandex.net',
        imageGenerator: 'https://travel-tools.yandex.net/image-generator',
        templator: 'http://templator.vs.market.yandex.net:29338/tarantino',
        reviews: 'https://rasp.s3.yandex.net/reviews',
        levelTravel: 'https://api.level.travel',
        hotelsExtranet:
            'https://api-prod.travel-hotels.yandex.net/api/hotels_extranet',
    }),
    experiments: {
        // Common

        // Trains
        skipSalesCheck: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },
        trainsAllowInternationalRoutes: {
            type: Boolean,
            defaultValue: false,
            denied: true,
        },

        // Avia
        enablePartnersFilter: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },
        isAviaPortal: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },

        // Hotels
        enableDebugHotelProdOffers: {
            type: Boolean,
            defaultValue: false,
            denied: true,
        },
    },
    orders: {
        canUseMockPayment: false,
        canUseTestContext: false,
    },
    uaas: {
        uri: 'http://uaas.search.yandex.net/travel',
        handler: 'TRAVEL',
        env: 'production',
    },
    cookieSession: {
        secret: process.env.COOKIE_SESSION_SECRET,
    },
    csrf: {
        secret: process.env.CSRF_TRAVEL_SECRET,
        lifetime: 7 * 24 * 60 * 60,
    },
    telemetryClickHouseEnvTable: 'env_production',
    travelTracing: {
        config: {
            serviceName: 'travel-front',
            disable: false,
            sampler: {
                type: 'probabilistic',
                param: 0.001,
            },
        },
    },
};
