import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import {isAviaSearchParams} from 'projects/avia/lib/search/isAviaSearchParams';

import {IDependencies} from 'server/getContainerConfig';
import {AviaFlexibleService} from 'server/services/AviaFlexibleService/AviaFlexibleService';

import {handleResponse} from '../handleResponse';
import {handleError} from '../handleError';

export class AviaFlexibleController {
    private aviaFlexibleService: AviaFlexibleService;

    constructor({aviaFlexibleService}: IDependencies) {
        this.aviaFlexibleService = aviaFlexibleService;
    }

    @logAction
    getSchedule(req: Request, res: Response): void {
        const params = req.query;

        if (!isAviaSearchParams(params)) {
            res.sendStatus(400);

            return;
        }

        this.aviaFlexibleService
            .getSchedule(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
