import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';

import {AviaFlightsToService} from 'server/services/AviaFlightsToService/AviaFlightsToService';
import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';

export class AviaFlightsToController {
    private aviaFlightsToService: AviaFlightsToService;

    constructor({aviaFlightsToService}: IDependencies) {
        this.aviaFlightsToService = aviaFlightsToService;
    }

    @logAction
    getFlightsToData(req: Request, res: Response): void {
        this.aviaFlightsToService
            .getFlightsToData(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
