import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';

import {IDependencies} from 'server/getContainerConfig';
import {handleError} from 'server/controllers/handleError';
import {handleResponse} from 'server/controllers/handleResponse';
import {AviaGeoService} from 'server/services/AviaGeoService/AviaGeoService';

export class AviaGeoController {
    private aviaGeoService: AviaGeoService;

    constructor({aviaGeoService}: IDependencies) {
        this.aviaGeoService = aviaGeoService;
    }

    @logAction
    getDataByPointKey(req: Request, res: Response): void {
        this.aviaGeoService
            .getDataByPointKey(req.query.key)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    getCountry(req: Request, res: Response): void {
        this.aviaGeoService
            .getCountry(req.query.id)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    getCountries(req: Request, res: Response): void {
        this.aviaGeoService
            .getCountries()
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    getDataByGeoId(req: Request, res: Response): void {
        this.aviaGeoService
            .getDataByGeoId(req.query.id)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    getDirectionsData(req: Request, res: Response): void {
        this.aviaGeoService
            .getDirectionsData(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
