import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';

import {IDependencies} from 'server/getContainerConfig';
import {AviaRouteService} from 'server/services/AviaRouteService/AviaRouteService';

import {handleResponse} from '../handleResponse';
import {handleError} from '../handleError';

export class AviaRouteController {
    private aviaRouteService: AviaRouteService;

    constructor({aviaRouteService}: IDependencies) {
        this.aviaRouteService = aviaRouteService;
    }

    @logAction
    getRouteData(req: Request, res: Response): void {
        this.aviaRouteService
            .getRouteData(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
