import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {AviaSettlementSlugService} from 'server/services/AviaSettlementSlugService/AviaSettlementSlugService';

import {handleResponse} from '../handleResponse';
import {handleError} from '../handleError';

export class AviaSettlementSlugController {
    private aviaSettlementSlugService: AviaSettlementSlugService;

    constructor({aviaSettlementSlugService}: IDependencies) {
        this.aviaSettlementSlugService = aviaSettlementSlugService;
    }

    @logAction
    @requestMethod('GET')
    getSettlementSlugByGeoId(req: Request, res: Response): void {
        this.aviaSettlementSlugService
            .getSettlementSlugByGeoId(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
