import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import {authorize} from 'server/utilities/decorators/authorize';

import {IDependencies} from 'server/getContainerConfig';
import {AviaSubscriptionService} from 'server/services/AviaSubscriptionService';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';

export class AviaSubscriptionController {
    private subscriptionService: AviaSubscriptionService;

    constructor({aviaSubscriptionService}: IDependencies) {
        this.subscriptionService = aviaSubscriptionService;
    }

    @authorize
    @logAction
    subscriptions(req: Request, res: Response): void {
        this.subscriptionService
            .subscriptions(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    subscribe(req: Request, res: Response): void {
        this.subscriptionService
            .subscribe(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    subscribeByEmail(req: Request, res: Response): void {
        this.subscriptionService
            .subscribeByEmail(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    unsubscribeByDirection(req: Request, res: Response): void {
        this.subscriptionService
            .unsubscribeByDirection(req.body)
            .then(handleResponse(res), handleError(res));
    }
}
