import {Request, Response} from '@yandex-data-ui/core/lib/types';
import {IBookingFormData} from 'projects/avia/pages/AviaBooking/types/IBookingFormData';

import {logAction} from 'server/utilities/decorators/logAction';

import {IDependencies} from 'server/getContainerConfig';
import {AviaTravelersNotebookService} from 'server/services/AviaTravelersNotebookService/AviaTravelersNotebookService';

import {handleResponse} from '../handleResponse';
import {handleError} from '../handleError';

export class AviaTravellersController {
    private aviaTravalersNotebookService: AviaTravelersNotebookService;

    constructor({aviaTravalersNotebookService}: IDependencies) {
        this.aviaTravalersNotebookService = aviaTravalersNotebookService;
    }

    @logAction
    getNotebook(_req: Request, res: Response): void {
        this.aviaTravalersNotebookService
            .getTravelersNotebook()
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    saveTravellerNotebook(req: Request, res: Response): void {
        const data: IBookingFormData = req.body;

        this.aviaTravalersNotebookService
            .saveTravelerNotebookFromSubmit(data)
            .then(handleResponse(res), handleError(res));
    }
}
