import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {AviaBookingController} from './AviaBookingController';
import {AviaTravellersController} from './AviaTravellersController';
import {AviaSearchController} from './AviaSearchController';
import {AviaRedirectController} from './AviaRedirectController';
import {AviaSubscriptionController} from './AviaSubscriptionController';
import {AviaGeoController} from './AviaGeoController';
import {AviaPriceIndexController} from './AviaPriceIndexController';
import {AviaClientLoggingController} from './AviaClientLoggingController';
import {AviaFlexibleController} from './AviaFlexibleController';
import {AviaRouteController} from './AviaRouteController';
import {AviaSettlementSlugController} from './AviaSettlementSlugController';
import {AviaController} from './AviaController';
import {AviaFlightsToController} from './AviaFlightsToController';

const aviaBookingController = makeProxyInvoker(AviaBookingController);
const aviaTravalersController = makeProxyInvoker(AviaTravellersController);
const aviaSearchController = makeProxyInvoker(AviaSearchController);
const aviaRedirectController = makeProxyInvoker(AviaRedirectController);
const aviaSubscriptionController = makeProxyInvoker(AviaSubscriptionController);
const aviaGeoController = makeProxyInvoker(AviaGeoController);
const aviaPriceIndexController = makeProxyInvoker(AviaPriceIndexController);
const aviaClientLoggingController = makeProxyInvoker(
    AviaClientLoggingController,
);
const aviaFlexibleController = makeProxyInvoker(AviaFlexibleController);
const aviaRouteController = makeProxyInvoker(AviaRouteController);
const aviaFlightsToController = makeProxyInvoker(AviaFlightsToController);
const aviaSettlementSlugController = makeProxyInvoker(
    AviaSettlementSlugController,
);
const aviaController = makeProxyInvoker(AviaController);

export default {
    searchSuggest: aviaController.getSuggests,
    booking: {
        variants: aviaBookingController.getVariants,
        orders: aviaBookingController.getOrder,
        testContext: aviaBookingController.getTestContextToken,
        'create-order': aviaBookingController.createOrder,
        'confirmation-complete': aviaBookingController.confirmationComplete,
        'composite-state': aviaBookingController.getCompositeState,
        'payments-async': aviaBookingController.initPaymentAsync,
    },
    travelers: {
        notebook: aviaTravalersController.getNotebook,
        orders: aviaTravalersController.saveTravellerNotebook,
    },
    search: {
        init: aviaSearchController.initByQuery,
        results: aviaSearchController.results,
        'popular-flights': aviaSearchController.topFlights,
        'popular-partners': aviaSearchController.getPopuplarPartners,
    },
    flexible: {
        schedule: aviaFlexibleController.getSchedule,
    },
    order: {
        variant: aviaSearchController.getOrder,
        update: aviaSearchController.update,
        passengerExperience: aviaSearchController.passengerExperience,
        goodPrice: aviaSearchController.getGoodPrice,
    },
    redirect: {
        redirect: aviaRedirectController.longRedirect,
        check: aviaRedirectController.checkVariantExistence,
    },
    nearAirports: aviaSearchController.getNearAirports,
    subscription: {
        subscriptions: aviaSubscriptionController.subscriptions,
        subscribe: aviaSubscriptionController.subscribe,
        'subscribe-by-email': aviaSubscriptionController.subscribeByEmail,
        'unsubscribe-by-direction':
            aviaSubscriptionController.unsubscribeByDirection,
    },
    partnersInfo: aviaSearchController.getPartnersInfo,
    dataByPointKey: aviaGeoController.getDataByPointKey,
    geo: {
        getCountry: aviaGeoController.getCountry,
        getCountries: aviaGeoController.getCountries,
        getDataByGeoId: aviaGeoController.getDataByGeoId,
        getDirectionsData: aviaGeoController.getDirectionsData,
    },
    dynamics: aviaPriceIndexController.dynamics,
    'calendar-prices': aviaPriceIndexController.calendar,
    minPriceBatchSearch: aviaPriceIndexController.minPriceBatchSearch,
    log: {
        userSearch: aviaClientLoggingController.userSearch,
        show: aviaClientLoggingController.show,
        action: aviaClientLoggingController.action,
        landingVisit: aviaClientLoggingController.landingVisit,
    },
    route: aviaRouteController.getRouteData,
    flightsTo: aviaFlightsToController.getFlightsToData,
    geoLookup: aviaController.getGeoLookup,
    settlementSlugByGeoId:
        aviaSettlementSlugController.getSettlementSlugByGeoId,
    getFlightPage: aviaController.getFlightPage,
    getOrder: aviaController.getOrder,
    extendedCountryRestrictions: aviaController.getExtendedCountryRestrictions,
    searchToCountry: aviaController.getSearchToCountry,
    searchToAnywhere: aviaController.getSearchToAnywhere,
};
