import moment from 'moment';

import {IFlightDate} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

export function dateStringToShortDateString(
    date: IFlightDate | null,
): string | undefined {
    if (!date) {
        return;
    }

    const d = moment(date.local);

    if (d.isValid()) {
        return d.format('MMDDTHHmm');
    }
}

export function dateStringToIsoDateString(
    date: IFlightDate,
): string | undefined {
    const d = moment(date.local);

    if (d.isValid()) {
        return d.format('YYYY-MM-DD');
    }
}
