import {URL} from 'url';
import path from 'path';

import {EProjectName} from 'constants/common';
import {URLs} from 'constants/urls';

import {EAviaLandingName} from 'server/loggers/avia/AviaLandingVisitLog/types/EAviaLandingName';

export function getLandingName(ref: string): EAviaLandingName {
    try {
        const {pathname} = new URL(ref);

        const projectName = [
            EProjectName.INDEX,
            EProjectName.AVIA,
            EProjectName.TRAINS,
            EProjectName.HOTELS,
        ].find(
            project => path.basename(pathname) === path.basename(URLs[project]),
        );

        if (!projectName) {
            return EAviaLandingName.UNKNOWN;
        }

        const projectToLanding = {
            [EProjectName.INDEX]: EAviaLandingName.INDEX,
            [EProjectName.AVIA]: EAviaLandingName.INDEX_AVIA,
            [EProjectName.TRAINS]: EAviaLandingName.INDEX_TRAINS,
            [EProjectName.HOTELS]: EAviaLandingName.INDEX_HOTELS,
        };

        // @ts-ignore
        return projectToLanding[projectName] || EAviaLandingName.UNKNOWN;
    } catch (e) {
        return EAviaLandingName.UNKNOWN;
    }
}
