import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';
import {BunkerService} from 'server/services/BunkerService/BunkerService';

export class BunkerApiController {
    private bunkerService: BunkerService;

    constructor({bunkerService}: IDependencies) {
        this.bunkerService = bunkerService;
    }

    @logAction
    @requestMethod('GET')
    getTrainPopularRoutes(req: Request, res: Response): void {
        this.bunkerService
            .getTrainPopularRoutes()
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getFeatureFlags(req: Request, res: Response): void {
        this.bunkerService
            .getFeatureFlags()
            .then(handleResponse(res), handleError(res));
    }
}
