import {Request, Response} from '@yandex-data-ui/core/lib/types';
import {IBusesCreateRideOfferServiceParams} from 'server/services/BusesService/types/IBusesCreateRideOfferService';
import {IBusesCreateRideOfferBrowserProviderParams} from 'serviceProvider/buses/types/IBusesCreateRideOfferBrowserProviderParams';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';
import {BusesService} from 'server/services/BusesService/BusesService';

export class BusesApiController {
    private busesService: BusesService;

    constructor({busesService}: IDependencies) {
        this.busesService = busesService;
    }

    @logAction
    @requestMethod('GET')
    getSuggests(req: Request, res: Response): void {
        this.busesService
            .getSuggests(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getGeoPoints(req: Request, res: Response): void {
        this.busesService
            .getGeoPoints(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getPopularDirections(req: Request, res: Response): void {
        this.busesService
            .getPopularDirections(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getSegments(req: Request, res: Response): void {
        this.busesService
            .getSegments(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getCalendar(req: Request, res: Response): void {
        this.busesService
            .getCalendar(req.query)
            .then(handleResponse(res), handleError(res));
    }

    // TODO: убрать при переходе на покупку на портале
    @logAction
    @requestMethod('GET')
    getRide(req: Request, res: Response): void {
        this.busesService
            .getRide(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('POST')
    createRideOffer(req: Request, res: Response): void {
        const serviceParams: IBusesCreateRideOfferServiceParams = {
            ...(req.body as IBusesCreateRideOfferBrowserProviderParams),
            wizardReqId: req.visitSourceIds?.wizardReqId || undefined,
        };

        this.busesService
            .createRideOffer(serviceParams)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getDirection(req: Request, res: Response): void {
        this.busesService
            .getDirection(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getTestContext(req: Request, res: Response): void {
        this.busesService
            .getTestContext(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
