import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requiredParams from 'server/utilities/decorators/requiredParams';

import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';
import {CommonService} from 'server/services/CommonService/CommonService';

export class CommonController {
    private commonsService: CommonService;

    constructor({commonService}: IDependencies) {
        this.commonsService = commonService;
    }

    @logAction
    @requiredParams(['type'])
    getCrossLinks(req: Request, res: Response): void {
        this.commonsService
            .getCrossLinks(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    getUserYandexPlusInfo(req: Request, res: Response): void {
        this.commonsService
            .getUserYandexPlusInfo()
            .then(handleResponse(res), handleError(res));
    }
}
