import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {handleError} from 'server/controllers/handleError';
import {GeobaseApi} from 'server/api/GeobaseApi/GeobaseApi';
import {handleResponse} from 'server/controllers/handleResponse';

export class CountriesController {
    private geobaseApi: GeobaseApi;

    constructor({geobaseApi}: IDependencies) {
        this.geobaseApi = geobaseApi;
    }

    @logAction
    @requestMethod('GET')
    getCountries(req: Request, res: Response): void {
        this.geobaseApi
            .getRegionsByType(3)
            .then(handleResponse(res), handleError(res));
    }
}
