import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';

import {IDependencies} from 'server/getContainerConfig';
import {GeobaseService} from 'server/services/GeobaseService/GeobaseService';

import {handleResponse} from '../handleResponse';
import {handleError} from '../handleError';

export class GeobaseApiController {
    private geobaseService: GeobaseService;

    constructor({geobaseService}: IDependencies) {
        this.geobaseService = geobaseService;
    }

    @logAction
    getUserGeoLocation(_: Request, res: Response): void {
        this.geobaseService
            .getUserGeoLocation()
            .then(handleResponse(res))
            .catch(handleError(res));
    }
}
