import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requiredParams from 'server/utilities/decorators/requiredParams';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {handleError} from 'server/controllers/handleError';
import {handleResponse} from 'server/controllers/handleResponse';
import {NotifierService} from 'server/services/NotifierService/NotifierService';

export class NotifierController {
    private notifierService: NotifierService;

    constructor({notifierService}: IDependencies) {
        this.notifierService = notifierService;
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['email'])
    getStatus(req: Request, res: Response): void {
        this.notifierService
            .getStatus(req.query.email)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['vertical'])
    getPromoConfig(req: Request, res: Response): void {
        this.notifierService
            .getPromoConfig(req.query.vertical, req.query.email)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('POST')
    subscribe(req: Request, res: Response): void {
        this.notifierService
            .subscribe({
                email: req.body.email,
                name: req.body.name,
                timezone: req.body.timezone,
                language: req.body.language,
                source: req.body.source,
                travelVerticalName: req.body.travelVerticalName,
                promoSubscriptionCode: req.body.promoSubscriptionCode,
                nationalVersion: req.body.nationalVersion,
            })
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['id'])
    unsubscribe(req: Request, res: Response): void {
        this.notifierService
            .unsubscribe(req.query.id)
            .then(handleResponse(res), handleError(res));
    }
}
